/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about your Savings Plans Purchase Recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseRecommendationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseRecommendationMetadata.Builder, SavingsPlansPurchaseRecommendationMetadata> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationMetadata::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationMetadata::generationTimestamp))
            .setter(setter(Builder::generationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            GENERATION_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String generationTimestamp;

    private SavingsPlansPurchaseRecommendationMetadata(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationTimestamp = builder.generationTimestamp;
    }

    /**
     * <p>
     * The unique identifier for the recommendation set.
     * </p>
     * 
     * @return The unique identifier for the recommendation set.
     */
    public String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The timestamp showing when the recommendations were generated.
     * </p>
     * 
     * @return The timestamp showing when the recommendations were generated.
     */
    public String generationTimestamp() {
        return generationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendationMetadata)) {
            return false;
        }
        SavingsPlansPurchaseRecommendationMetadata other = (SavingsPlansPurchaseRecommendationMetadata) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(generationTimestamp(), other.generationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansPurchaseRecommendationMetadata").add("RecommendationId", recommendationId())
                .add("GenerationTimestamp", generationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "GenerationTimestamp":
            return Optional.ofNullable(clazz.cast(generationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendationMetadata, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseRecommendationMetadata> {
        /**
         * <p>
         * The unique identifier for the recommendation set.
         * </p>
         * 
         * @param recommendationId
         *        The unique identifier for the recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The timestamp showing when the recommendations were generated.
         * </p>
         * 
         * @param generationTimestamp
         *        The timestamp showing when the recommendations were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationTimestamp(String generationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String generationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendationMetadata model) {
            recommendationId(model.recommendationId);
            generationTimestamp(model.generationTimestamp);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final String getGenerationTimestamp() {
            return generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        @Override
        public SavingsPlansPurchaseRecommendationMetadata build() {
            return new SavingsPlansPurchaseRecommendationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
