/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTagsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetTagsRequest.Builder, GetTagsRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTagsRequest::searchString)).setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetTagsRequest::timePeriod)).setter(setter(Builder::timePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTagsRequest::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTagsRequest::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD,
            TIME_PERIOD_FIELD, TAG_KEY_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final String searchString;

    private final DateInterval timePeriod;

    private final String tagKey;

    private final String nextPageToken;

    private GetTagsRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.tagKey = builder.tagKey;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The value that you want to search for.
     * </p>
     * 
     * @return The value that you want to search for.
     */
    public String searchString() {
        return searchString;
    }

    /**
     * <p>
     * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
     * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     * </p>
     * 
     * @return The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
     *         date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     *         <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     *         including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     */
    public DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The key of the tag that you want to return values for.
     * </p>
     * 
     * @return The key of the tag that you want to return values for.
     */
    public String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. AWS provides the token when the response from a previous call has
     * more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. AWS provides the token when the response from a previous
     *         call has more results than the maximum page size.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsRequest)) {
            return false;
        }
        GetTagsRequest other = (GetTagsRequest) obj;
        return Objects.equals(searchString(), other.searchString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(tagKey(), other.tagKey()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTagsRequest").add("SearchString", searchString()).add("TimePeriod", timePeriod())
                .add("TagKey", tagKey()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagsRequest, T> g) {
        return obj -> g.apply((GetTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTagsRequest> {
        /**
         * <p>
         * The value that you want to search for.
         * </p>
         * 
         * @param searchString
         *        The value that you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * 
         * @param timePeriod
         *        The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
         *        date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code>
         *        is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up
         *        to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The key of the tag that you want to return values for.
         * </p>
         * 
         * @param tagKey
         *        The key of the tag that you want to return values for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The token to retrieve the next set of results. AWS provides the token when the response from a previous call
         * has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String searchString;

        private DateInterval timePeriod;

        private String tagKey;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsRequest model) {
            super(model);
            searchString(model.searchString);
            timePeriod(model.timePeriod);
            tagKey(model.tagKey);
            nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getTagKey() {
            return tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTagsRequest build() {
            return new GetTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
