/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetSavingsPlansUtilizationRequest.Builder, GetSavingsPlansUtilizationRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSavingsPlansUtilizationRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansUtilizationRequest::granularityAsString)).setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSavingsPlansUtilizationRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            GRANULARITY_FIELD, FILTER_FIELD));

    private final DateInterval timePeriod;

    private final String granularity;

    private final Expression filter;

    private GetSavingsPlansUtilizationRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The
     * <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't
     * be used as an <code>End</code> date.
     * </p>
     * 
     * @return The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
     *         months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date.
     *         Future dates can't be used as an <code>End</code> date.
     */
    public DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services utillization data for your Savings Plans.
     * </p>
     * <p>
     * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
     *         <p>
     *         The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services utillization data for your Savings Plans.
     * </p>
     * <p>
     * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
     *         <p>
     *         The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the
     * following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LINKED_ACCOUNT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLAN_ARN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAVINGS_PLANS_TYPE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAYMENT_OPTION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE_TYPE_FAMILY</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>GetSavingsPlansUtilization</code> uses the same <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object as the other operations, but only <code>AND</code> is supported among each dimension.
     * </p>
     * 
     * @return Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data
     *         with the following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LINKED_ACCOUNT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLAN_ARN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAVINGS_PLANS_TYPE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAYMENT_OPTION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE_TYPE_FAMILY</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>GetSavingsPlansUtilization</code> uses the same <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
     *         dimension.
     */
    public Expression filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationRequest)) {
            return false;
        }
        GetSavingsPlansUtilizationRequest other = (GetSavingsPlansUtilizationRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSavingsPlansUtilizationRequest").add("TimePeriod", timePeriod())
                .add("Granularity", granularityAsString()).add("Filter", filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationRequest> {
        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * 
         * @param timePeriod
         *        The time period that you want the usage and costs for. The <code>Start</code> date must be within 13
         *        months. The <code>End</code> date must be after the <code>Start</code> date, and before the current
         *        date. Future dates can't be used as an <code>End</code> date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months.
         * The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future
         * dates can't be used as an <code>End</code> date.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The granularity of the Amazon Web Services utillization data for your Savings Plans.
         * </p>
         * <p>
         * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         * <code>MONTHLY</code> granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
         *        <p>
         *        The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The granularity of the Amazon Web Services utillization data for your Savings Plans.
         * </p>
         * <p>
         * The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         * <code>MONTHLY</code> granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
         *        <p>
         *        The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLANS_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilization</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * 
         * @param filter
         *        Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter
         *        data with the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LINKED_ACCOUNT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLAN_ARN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAVINGS_PLANS_TYPE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAYMENT_OPTION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE_TYPE_FAMILY</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>GetSavingsPlansUtilization</code> uses the same <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
         *        dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with
         * the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LINKED_ACCOUNT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLAN_ARN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAVINGS_PLANS_TYPE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAYMENT_OPTION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE_TYPE_FAMILY</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetSavingsPlansUtilization</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension.
         * </p>
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private String granularity;

        private Expression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            granularity(model.granularity);
            filter(model.filter);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getGranularity() {
            return granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansUtilizationRequest build() {
            return new GetSavingsPlansUtilizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
