/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationUtilizationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetReservationUtilizationResponse.Builder, GetReservationUtilizationResponse> {
    private static final SdkField<List<UtilizationByTime>> UTILIZATIONS_BY_TIME_FIELD = SdkField
            .<List<UtilizationByTime>> builder(MarshallingType.LIST)
            .getter(getter(GetReservationUtilizationResponse::utilizationsByTime))
            .setter(setter(Builder::utilizationsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UtilizationByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(UtilizationByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReservationAggregates> TOTAL_FIELD = SdkField
            .<ReservationAggregates> builder(MarshallingType.SDK_POJO).getter(getter(GetReservationUtilizationResponse::total))
            .setter(setter(Builder::total)).constructor(ReservationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetReservationUtilizationResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATIONS_BY_TIME_FIELD,
            TOTAL_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<UtilizationByTime> utilizationsByTime;

    private final ReservationAggregates total;

    private final String nextPageToken;

    private GetReservationUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.utilizationsByTime = builder.utilizationsByTime;
        this.total = builder.total;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the UtilizationsByTime property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUtilizationsByTime() {
        return utilizationsByTime != null && !(utilizationsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of time that you used your RIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUtilizationsByTime()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The amount of time that you used your RIs.
     */
    public List<UtilizationByTime> utilizationsByTime() {
        return utilizationsByTime;
    }

    /**
     * <p>
     * The total amount of time that you used your RIs.
     * </p>
     * 
     * @return The total amount of time that you used your RIs.
     */
    public ReservationAggregates total() {
        return total;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. AWS provides the token when the response from a previous call
     * has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. AWS provides the token when the response from a
     *         previous call has more results than the maximum page size.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(utilizationsByTime());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationUtilizationResponse)) {
            return false;
        }
        GetReservationUtilizationResponse other = (GetReservationUtilizationResponse) obj;
        return Objects.equals(utilizationsByTime(), other.utilizationsByTime()) && Objects.equals(total(), other.total())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReservationUtilizationResponse").add("UtilizationsByTime", utilizationsByTime())
                .add("Total", total()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UtilizationsByTime":
            return Optional.ofNullable(clazz.cast(utilizationsByTime()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationUtilizationResponse, T> g) {
        return obj -> g.apply((GetReservationUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationUtilizationResponse> {
        /**
         * <p>
         * The amount of time that you used your RIs.
         * </p>
         * 
         * @param utilizationsByTime
         *        The amount of time that you used your RIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationsByTime(Collection<UtilizationByTime> utilizationsByTime);

        /**
         * <p>
         * The amount of time that you used your RIs.
         * </p>
         * 
         * @param utilizationsByTime
         *        The amount of time that you used your RIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilizationsByTime(UtilizationByTime... utilizationsByTime);

        /**
         * <p>
         * The amount of time that you used your RIs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UtilizationByTime>.Builder} avoiding the
         * need to create one manually via {@link List<UtilizationByTime>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UtilizationByTime>.Builder#build()} is called immediately
         * and its result is passed to {@link #utilizationsByTime(List<UtilizationByTime>)}.
         * 
         * @param utilizationsByTime
         *        a consumer that will call methods on {@link List<UtilizationByTime>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilizationsByTime(List<UtilizationByTime>)
         */
        Builder utilizationsByTime(Consumer<UtilizationByTime.Builder>... utilizationsByTime);

        /**
         * <p>
         * The total amount of time that you used your RIs.
         * </p>
         * 
         * @param total
         *        The total amount of time that you used your RIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(ReservationAggregates total);

        /**
         * <p>
         * The total amount of time that you used your RIs.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationAggregates.Builder} avoiding the need
         * to create one manually via {@link ReservationAggregates#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationAggregates.Builder#build()} is called immediately and
         * its result is passed to {@link #total(ReservationAggregates)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link ReservationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(ReservationAggregates)
         */
        default Builder total(Consumer<ReservationAggregates.Builder> total) {
            return total(ReservationAggregates.builder().applyMutation(total).build());
        }

        /**
         * <p>
         * The token for the next set of retrievable results. AWS provides the token when the response from a previous
         * call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<UtilizationByTime> utilizationsByTime = DefaultSdkAutoConstructList.getInstance();

        private ReservationAggregates total;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationUtilizationResponse model) {
            super(model);
            utilizationsByTime(model.utilizationsByTime);
            total(model.total);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<UtilizationByTime.Builder> getUtilizationsByTime() {
            return utilizationsByTime != null ? utilizationsByTime.stream().map(UtilizationByTime::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utilizationsByTime(Collection<UtilizationByTime> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copy(utilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(UtilizationByTime... utilizationsByTime) {
            utilizationsByTime(Arrays.asList(utilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(Consumer<UtilizationByTime.Builder>... utilizationsByTime) {
            utilizationsByTime(Stream.of(utilizationsByTime).map(c -> UtilizationByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUtilizationsByTime(Collection<UtilizationByTime.BuilderImpl> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copyFromBuilder(utilizationsByTime);
        }

        public final ReservationAggregates.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        @Override
        public final Builder total(ReservationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(ReservationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetReservationUtilizationResponse build() {
            return new GetReservationUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
