/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the Amazon ElastiCache instances that AWS recommends that you purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElastiCacheInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ElastiCacheInstanceDetails.Builder, ElastiCacheInstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ElastiCacheInstanceDetails::family)).setter(setter(Builder::family))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ElastiCacheInstanceDetails::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ElastiCacheInstanceDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ElastiCacheInstanceDetails::productDescription)).setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ElastiCacheInstanceDetails::currentGeneration)).setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()).build();

    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ElastiCacheInstanceDetails::sizeFlexEligible)).setter(setter(Builder::sizeFlexEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, NODE_TYPE_FIELD,
            REGION_FIELD, PRODUCT_DESCRIPTION_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String family;

    private final String nodeType;

    private final String region;

    private final String productDescription;

    private final Boolean currentGeneration;

    private final Boolean sizeFlexEligible;

    private ElastiCacheInstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.nodeType = builder.nodeType;
        this.region = builder.region;
        this.productDescription = builder.productDescription;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    /**
     * <p>
     * The instance family of the recommended reservation.
     * </p>
     * 
     * @return The instance family of the recommended reservation.
     */
    public String family() {
        return family;
    }

    /**
     * <p>
     * The type of node that AWS recommends.
     * </p>
     * 
     * @return The type of node that AWS recommends.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The AWS Region of the recommended reservation.
     * </p>
     * 
     * @return The AWS Region of the recommended reservation.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The description of the recommended reservation.
     * </p>
     * 
     * @return The description of the recommended reservation.
     */
    public String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * Whether the recommendation is for a current generation instance.
     * </p>
     * 
     * @return Whether the recommendation is for a current generation instance.
     */
    public Boolean currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * Whether the recommended reservation is size flexible.
     * </p>
     * 
     * @return Whether the recommended reservation is size flexible.
     */
    public Boolean sizeFlexEligible() {
        return sizeFlexEligible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(family());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(sizeFlexEligible());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElastiCacheInstanceDetails)) {
            return false;
        }
        ElastiCacheInstanceDetails other = (ElastiCacheInstanceDetails) obj;
        return Objects.equals(family(), other.family()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(region(), other.region()) && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(sizeFlexEligible(), other.sizeFlexEligible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ElastiCacheInstanceDetails").add("Family", family()).add("NodeType", nodeType())
                .add("Region", region()).add("ProductDescription", productDescription())
                .add("CurrentGeneration", currentGeneration()).add("SizeFlexEligible", sizeFlexEligible()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Family":
            return Optional.ofNullable(clazz.cast(family()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "CurrentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "SizeFlexEligible":
            return Optional.ofNullable(clazz.cast(sizeFlexEligible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElastiCacheInstanceDetails, T> g) {
        return obj -> g.apply((ElastiCacheInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElastiCacheInstanceDetails> {
        /**
         * <p>
         * The instance family of the recommended reservation.
         * </p>
         * 
         * @param family
         *        The instance family of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder family(String family);

        /**
         * <p>
         * The type of node that AWS recommends.
         * </p>
         * 
         * @param nodeType
         *        The type of node that AWS recommends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The AWS Region of the recommended reservation.
         * </p>
         * 
         * @param region
         *        The AWS Region of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The description of the recommended reservation.
         * </p>
         * 
         * @param productDescription
         *        The description of the recommended reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * Whether the recommendation is for a current generation instance.
         * </p>
         * 
         * @param currentGeneration
         *        Whether the recommendation is for a current generation instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(Boolean currentGeneration);

        /**
         * <p>
         * Whether the recommended reservation is size flexible.
         * </p>
         * 
         * @param sizeFlexEligible
         *        Whether the recommended reservation is size flexible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeFlexEligible(Boolean sizeFlexEligible);
    }

    static final class BuilderImpl implements Builder {
        private String family;

        private String nodeType;

        private String region;

        private String productDescription;

        private Boolean currentGeneration;

        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(ElastiCacheInstanceDetails model) {
            family(model.family);
            nodeType(model.nodeType);
            region(model.region);
            productDescription(model.productDescription);
            currentGeneration(model.currentGeneration);
            sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final Boolean getCurrentGeneration() {
            return currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        public ElastiCacheInstanceDetails build() {
            return new ElastiCacheInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
