/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCostCategoryDefinitionResponse extends CostExplorerResponse implements
        ToCopyableBuilder<CreateCostCategoryDefinitionResponse.Builder, CreateCostCategoryDefinitionResponse> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCostCategoryDefinitionResponse::costCategoryArn)).setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCostCategoryDefinitionResponse::effectiveStart)).setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            EFFECTIVE_START_FIELD));

    private final String costCategoryArn;

    private final String effectiveStart;

    private CreateCostCategoryDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveStart = builder.effectiveStart;
    }

    /**
     * <p>
     * The unique identifier for your newly created Cost Category.
     * </p>
     * 
     * @return The unique identifier for your newly created Cost Category.
     */
    public String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * <p>
     * The Cost Category's effective start date.
     * </p>
     * 
     * @return The Cost Category's effective start date.
     */
    public String effectiveStart() {
        return effectiveStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCostCategoryDefinitionResponse)) {
            return false;
        }
        CreateCostCategoryDefinitionResponse other = (CreateCostCategoryDefinitionResponse) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn())
                && Objects.equals(effectiveStart(), other.effectiveStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCostCategoryDefinitionResponse").add("CostCategoryArn", costCategoryArn())
                .add("EffectiveStart", effectiveStart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "EffectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCostCategoryDefinitionResponse, T> g) {
        return obj -> g.apply((CreateCostCategoryDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCostCategoryDefinitionResponse> {
        /**
         * <p>
         * The unique identifier for your newly created Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your newly created Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * <p>
         * The Cost Category's effective start date.
         * </p>
         * 
         * @param effectiveStart
         *        The Cost Category's effective start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(String effectiveStart);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String costCategoryArn;

        private String effectiveStart;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCostCategoryDefinitionResponse model) {
            super(model);
            costCategoryArn(model.costCategoryArn);
            effectiveStart(model.effectiveStart);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getEffectiveStart() {
            return effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public CreateCostCategoryDefinitionResponse build() {
            return new CreateCostCategoryDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
