/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a Cost Category containing only enough information to identify the Cost Category.
 * </p>
 * <p>
 * You can use this information to retrieve the full Cost Category information using <code>DescribeCostCategory</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryReference implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryReference.Builder, CostCategoryReference> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategoryReference::costCategoryArn)).setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategoryReference::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategoryReference::effectiveStart)).setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()).build();

    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategoryReference::effectiveEnd)).setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RULES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CostCategoryReference::numberOfRules)).setter(setter(Builder::numberOfRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            NAME_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NUMBER_OF_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String costCategoryArn;

    private final String name;

    private final String effectiveStart;

    private final String effectiveEnd;

    private final Integer numberOfRules;

    private CostCategoryReference(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.name = builder.name;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.numberOfRules = builder.numberOfRules;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Cost Category's effective start date.
     * </p>
     * 
     * @return The Cost Category's effective start date.
     */
    public String effectiveStart() {
        return effectiveStart;
    }

    /**
     * <p>
     * The Cost Category's effective end date.
     * </p>
     * 
     * @return The Cost Category's effective end date.
     */
    public String effectiveEnd() {
        return effectiveEnd;
    }

    /**
     * <p>
     * The number of rules associated with a specific Cost Category.
     * </p>
     * 
     * @return The number of rules associated with a specific Cost Category.
     */
    public Integer numberOfRules() {
        return numberOfRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryReference)) {
            return false;
        }
        CostCategoryReference other = (CostCategoryReference) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn()) && Objects.equals(name(), other.name())
                && Objects.equals(effectiveStart(), other.effectiveStart())
                && Objects.equals(effectiveEnd(), other.effectiveEnd()) && Objects.equals(numberOfRules(), other.numberOfRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CostCategoryReference").add("CostCategoryArn", costCategoryArn()).add("Name", name())
                .add("EffectiveStart", effectiveStart()).add("EffectiveEnd", effectiveEnd())
                .add("NumberOfRules", numberOfRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EffectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        case "EffectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        case "NumberOfRules":
            return Optional.ofNullable(clazz.cast(numberOfRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryReference, T> g) {
        return obj -> g.apply((CostCategoryReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryReference> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Cost Category's effective start date.
         * </p>
         * 
         * @param effectiveStart
         *        The Cost Category's effective start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(String effectiveStart);

        /**
         * <p>
         * The Cost Category's effective end date.
         * </p>
         * 
         * @param effectiveEnd
         *        The Cost Category's effective end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(String effectiveEnd);

        /**
         * <p>
         * The number of rules associated with a specific Cost Category.
         * </p>
         * 
         * @param numberOfRules
         *        The number of rules associated with a specific Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRules(Integer numberOfRules);
    }

    static final class BuilderImpl implements Builder {
        private String costCategoryArn;

        private String name;

        private String effectiveStart;

        private String effectiveEnd;

        private Integer numberOfRules;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryReference model) {
            costCategoryArn(model.costCategoryArn);
            name(model.name);
            effectiveStart(model.effectiveStart);
            effectiveEnd(model.effectiveEnd);
            numberOfRules(model.numberOfRules);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEffectiveStart() {
            return effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        public final String getEffectiveEnd() {
            return effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        public final Integer getNumberOfRules() {
            return numberOfRules;
        }

        @Override
        public final Builder numberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
            return this;
        }

        public final void setNumberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
        }

        @Override
        public CostCategoryReference build() {
            return new CostCategoryReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
