/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansCoverageData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansCoverage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansCoverage> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SavingsPlansCoverage.getter(SavingsPlansCoverage::attributes)).setter(SavingsPlansCoverage.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SavingsPlansCoverageData> COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SavingsPlansCoverage.getter(SavingsPlansCoverage::coverage)).setter(SavingsPlansCoverage.setter(Builder::coverage)).constructor(SavingsPlansCoverageData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coverage").build()}).build();
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SavingsPlansCoverage.getter(SavingsPlansCoverage::timePeriod)).setter(SavingsPlansCoverage.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, COVERAGE_FIELD, TIME_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attributes;
    private final SavingsPlansCoverageData coverage;
    private final DateInterval timePeriod;

    private SavingsPlansCoverage(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.coverage = builder.coverage;
        this.timePeriod = builder.timePeriod;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public SavingsPlansCoverageData coverage() {
        return this.coverage;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansCoverage)) {
            return false;
        }
        SavingsPlansCoverage other = (SavingsPlansCoverage)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.coverage(), other.coverage()) && Objects.equals(this.timePeriod(), other.timePeriod());
    }

    public String toString() {
        return ToString.builder((String)"SavingsPlansCoverage").add("Attributes", this.attributes()).add("Coverage", (Object)this.coverage()).add("TimePeriod", (Object)this.timePeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Coverage": {
                return Optional.ofNullable(clazz.cast(this.coverage()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansCoverage, T> g) {
        return obj -> g.apply((SavingsPlansCoverage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private SavingsPlansCoverageData coverage;
        private DateInterval timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansCoverage model) {
            this.attributes(model.attributes);
            this.coverage(model.coverage);
            this.timePeriod(model.timePeriod);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final SavingsPlansCoverageData.Builder getCoverage() {
            return this.coverage != null ? this.coverage.toBuilder() : null;
        }

        @Override
        public final Builder coverage(SavingsPlansCoverageData coverage) {
            this.coverage = coverage;
            return this;
        }

        public final void setCoverage(SavingsPlansCoverageData.BuilderImpl coverage) {
            this.coverage = coverage != null ? coverage.build() : null;
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public SavingsPlansCoverage build() {
            return new SavingsPlansCoverage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansCoverage> {
        public Builder attributes(Map<String, String> var1);

        public Builder coverage(SavingsPlansCoverageData var1);

        default public Builder coverage(Consumer<SavingsPlansCoverageData.Builder> coverage) {
            return this.coverage((SavingsPlansCoverageData)((SavingsPlansCoverageData.Builder)SavingsPlansCoverageData.builder().applyMutation(coverage)).build());
        }

        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }
    }
}

