/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCostCategoryDefinitionsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, ListCostCategoryDefinitionsRequest> {
    private static final SdkField<String> EFFECTIVE_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCostCategoryDefinitionsRequest.getter(ListCostCategoryDefinitionsRequest::effectiveOn)).setter(ListCostCategoryDefinitionsRequest.setter(Builder::effectiveOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveOn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCostCategoryDefinitionsRequest.getter(ListCostCategoryDefinitionsRequest::nextToken)).setter(ListCostCategoryDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_ON_FIELD, NEXT_TOKEN_FIELD));
    private final String effectiveOn;
    private final String nextToken;

    private ListCostCategoryDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.effectiveOn = builder.effectiveOn;
        this.nextToken = builder.nextToken;
    }

    public String effectiveOn() {
        return this.effectiveOn;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryDefinitionsRequest)) {
            return false;
        }
        ListCostCategoryDefinitionsRequest other = (ListCostCategoryDefinitionsRequest)((Object)obj);
        return Objects.equals(this.effectiveOn(), other.effectiveOn()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCostCategoryDefinitionsRequest").add("EffectiveOn", (Object)this.effectiveOn()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EffectiveOn": {
                return Optional.ofNullable(clazz.cast(this.effectiveOn()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryDefinitionsRequest, T> g) {
        return obj -> g.apply((ListCostCategoryDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String effectiveOn;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryDefinitionsRequest model) {
            super(model);
            this.effectiveOn(model.effectiveOn);
            this.nextToken(model.nextToken);
        }

        public final String getEffectiveOn() {
            return this.effectiveOn;
        }

        @Override
        public final Builder effectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final void setEffectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCostCategoryDefinitionsRequest build() {
            return new ListCostCategoryDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCostCategoryDefinitionsRequest> {
        public Builder effectiveOn(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

