/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.UtilizationByTime;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UtilizationByTimeMarshaller {
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Groups").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").isBinary(false).build();
    private static final UtilizationByTimeMarshaller INSTANCE = new UtilizationByTimeMarshaller();

    private UtilizationByTimeMarshaller() {
    }

    public static UtilizationByTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UtilizationByTime utilizationByTime, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)utilizationByTime, (String)"utilizationByTime");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)utilizationByTime.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall(utilizationByTime.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)utilizationByTime.total(), TOTAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

