/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.model.ServiceSpecification;
import software.amazon.awssdk.services.costexplorer.transform.EC2SpecificationUnmarshaller;

public class ServiceSpecificationUnmarshaller
implements Unmarshaller<ServiceSpecification, JsonUnmarshallerContext> {
    private static final ServiceSpecificationUnmarshaller INSTANCE = new ServiceSpecificationUnmarshaller();

    public ServiceSpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        ServiceSpecification.Builder serviceSpecificationBuilder = ServiceSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("EC2Specification", targetDepth)) {
                    context.nextToken();
                    serviceSpecificationBuilder.ec2Specification(EC2SpecificationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ServiceSpecification)serviceSpecificationBuilder.build();
    }

    public static ServiceSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

