/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.ResultByTime;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResultByTimeMarshaller {
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<Map> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Groups").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ESTIMATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Estimated").isBinary(false).build();
    private static final ResultByTimeMarshaller INSTANCE = new ResultByTimeMarshaller();

    private ResultByTimeMarshaller() {
    }

    public static ResultByTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultByTime resultByTime, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resultByTime, (String)"resultByTime");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resultByTime.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall(resultByTime.total(), TOTAL_BINDING);
            protocolMarshaller.marshall(resultByTime.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)resultByTime.estimated(), ESTIMATED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

