/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservationUtilizationGroupMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> UTILIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Utilization").isBinary(false).build();
    private static final ReservationUtilizationGroupMarshaller INSTANCE = new ReservationUtilizationGroupMarshaller();

    private ReservationUtilizationGroupMarshaller() {
    }

    public static ReservationUtilizationGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservationUtilizationGroup reservationUtilizationGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservationUtilizationGroup, (String)"reservationUtilizationGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reservationUtilizationGroup.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)reservationUtilizationGroup.value(), VALUE_BINDING);
            protocolMarshaller.marshall(reservationUtilizationGroup.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)reservationUtilizationGroup.utilization(), UTILIZATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

