/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservationPurchaseRecommendationMarshaller {
    private static final MarshallingInfo<String> ACCOUNTSCOPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountScope").isBinary(false).build();
    private static final MarshallingInfo<String> LOOKBACKPERIODINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LookbackPeriodInDays").isBinary(false).build();
    private static final MarshallingInfo<String> TERMINYEARS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TermInYears").isBinary(false).build();
    private static final MarshallingInfo<String> PAYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentOption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SERVICESPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceSpecification").isBinary(false).build();
    private static final MarshallingInfo<List> RECOMMENDATIONDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecommendationDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RECOMMENDATIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecommendationSummary").isBinary(false).build();
    private static final ReservationPurchaseRecommendationMarshaller INSTANCE = new ReservationPurchaseRecommendationMarshaller();

    private ReservationPurchaseRecommendationMarshaller() {
    }

    public static ReservationPurchaseRecommendationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservationPurchaseRecommendation reservationPurchaseRecommendation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservationPurchaseRecommendation, (String)"reservationPurchaseRecommendation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.accountScopeAsString(), ACCOUNTSCOPE_BINDING);
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.lookbackPeriodInDaysAsString(), LOOKBACKPERIODINDAYS_BINDING);
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.termInYearsAsString(), TERMINYEARS_BINDING);
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.paymentOptionAsString(), PAYMENTOPTION_BINDING);
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.serviceSpecification(), SERVICESPECIFICATION_BINDING);
            protocolMarshaller.marshall(reservationPurchaseRecommendation.recommendationDetails(), RECOMMENDATIONDETAILS_BINDING);
            protocolMarshaller.marshall((Object)reservationPurchaseRecommendation.recommendationSummary(), RECOMMENDATIONSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

