/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RedshiftInstanceDetailsMarshaller {
    private static final MarshallingInfo<String> FAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Family").isBinary(false).build();
    private static final MarshallingInfo<String> NODETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeType").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CURRENTGENERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentGeneration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SIZEFLEXELIGIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeFlexEligible").isBinary(false).build();
    private static final RedshiftInstanceDetailsMarshaller INSTANCE = new RedshiftInstanceDetailsMarshaller();

    private RedshiftInstanceDetailsMarshaller() {
    }

    public static RedshiftInstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftInstanceDetails redshiftInstanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)redshiftInstanceDetails, (String)"redshiftInstanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)redshiftInstanceDetails.family(), FAMILY_BINDING);
            protocolMarshaller.marshall((Object)redshiftInstanceDetails.nodeType(), NODETYPE_BINDING);
            protocolMarshaller.marshall((Object)redshiftInstanceDetails.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)redshiftInstanceDetails.currentGeneration(), CURRENTGENERATION_BINDING);
            protocolMarshaller.marshall((Object)redshiftInstanceDetails.sizeFlexEligible(), SIZEFLEXELIGIBLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

