/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.InstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceDetailsMarshaller {
    private static final MarshallingInfo<StructuredPojo> EC2INSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2InstanceDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RDSINSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSInstanceDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTINSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftInstanceDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICACHEINSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElastiCacheInstanceDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ESINSTANCEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ESInstanceDetails").isBinary(false).build();
    private static final InstanceDetailsMarshaller INSTANCE = new InstanceDetailsMarshaller();

    private InstanceDetailsMarshaller() {
    }

    public static InstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceDetails instanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceDetails, (String)"instanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceDetails.ec2InstanceDetails(), EC2INSTANCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.rdsInstanceDetails(), RDSINSTANCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.redshiftInstanceDetails(), REDSHIFTINSTANCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.elastiCacheInstanceDetails(), ELASTICACHEINSTANCEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)instanceDetails.esInstanceDetails(), ESINSTANCEDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

