/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetTagsRequestModelMarshaller {
    private static final MarshallingInfo<String> SEARCHSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SearchString").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<String> TAGKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagKey").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTPAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextPageToken").isBinary(false).build();
    private static final GetTagsRequestModelMarshaller INSTANCE = new GetTagsRequestModelMarshaller();

    private GetTagsRequestModelMarshaller() {
    }

    public static GetTagsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetTagsRequest getTagsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getTagsRequest), (String)"getTagsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getTagsRequest.searchString(), SEARCHSTRING_BINDING);
            protocolMarshaller.marshall((Object)getTagsRequest.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall((Object)getTagsRequest.tagKey(), TAGKEY_BINDING);
            protocolMarshaller.marshall((Object)getTagsRequest.nextPageToken(), NEXTPAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

