/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.transform.DimensionValuesUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.TagValuesUnmarshaller;

public class ExpressionUnmarshaller
implements Unmarshaller<Expression, JsonUnmarshallerContext> {
    private static final ExpressionUnmarshaller INSTANCE = new ExpressionUnmarshaller();

    public Expression unmarshall(JsonUnmarshallerContext context) throws Exception {
        Expression.Builder expressionBuilder = Expression.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Or", targetDepth)) {
                    context.nextToken();
                    expressionBuilder.or(new ListUnmarshaller((Unmarshaller)ExpressionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("And", targetDepth)) {
                    context.nextToken();
                    expressionBuilder.and(new ListUnmarshaller((Unmarshaller)ExpressionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Not", targetDepth)) {
                    context.nextToken();
                    expressionBuilder.not(ExpressionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    context.nextToken();
                    expressionBuilder.dimensions(DimensionValuesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    expressionBuilder.tags(TagValuesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Expression)expressionBuilder.build();
    }

    public static ExpressionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

