/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ESInstanceDetailsMarshaller {
    private static final MarshallingInfo<String> INSTANCECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceClass").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceSize").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CURRENTGENERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentGeneration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SIZEFLEXELIGIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeFlexEligible").isBinary(false).build();
    private static final ESInstanceDetailsMarshaller INSTANCE = new ESInstanceDetailsMarshaller();

    private ESInstanceDetailsMarshaller() {
    }

    public static ESInstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ESInstanceDetails esInstanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)esInstanceDetails, (String)"esInstanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)esInstanceDetails.instanceClass(), INSTANCECLASS_BINDING);
            protocolMarshaller.marshall((Object)esInstanceDetails.instanceSize(), INSTANCESIZE_BINDING);
            protocolMarshaller.marshall((Object)esInstanceDetails.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)esInstanceDetails.currentGeneration(), CURRENTGENERATION_BINDING);
            protocolMarshaller.marshall((Object)esInstanceDetails.sizeFlexEligible(), SIZEFLEXELIGIBLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

