/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EC2InstanceDetailsMarshaller {
    private static final MarshallingInfo<String> FAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Family").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();
    private static final MarshallingInfo<String> TENANCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tenancy").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CURRENTGENERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentGeneration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SIZEFLEXELIGIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeFlexEligible").isBinary(false).build();
    private static final EC2InstanceDetailsMarshaller INSTANCE = new EC2InstanceDetailsMarshaller();

    private EC2InstanceDetailsMarshaller() {
    }

    public static EC2InstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EC2InstanceDetails ec2InstanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2InstanceDetails, (String)"ec2InstanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2InstanceDetails.family(), FAMILY_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.tenancy(), TENANCY_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.currentGeneration(), CURRENTGENERATION_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceDetails.sizeFlexEligible(), SIZEFLEXELIGIBLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

