/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.model.DimensionValues;

public class DimensionValuesUnmarshaller
implements Unmarshaller<DimensionValues, JsonUnmarshallerContext> {
    private static final DimensionValuesUnmarshaller INSTANCE = new DimensionValuesUnmarshaller();

    public DimensionValues unmarshall(JsonUnmarshallerContext context) throws Exception {
        DimensionValues.Builder dimensionValuesBuilder = DimensionValues.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    dimensionValuesBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    dimensionValuesBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DimensionValues)dimensionValuesBuilder.build();
    }

    public static DimensionValuesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

