/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.CoverageHours;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CoverageHoursMarshaller {
    private static final MarshallingInfo<String> ONDEMANDHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnDemandHours").isBinary(false).build();
    private static final MarshallingInfo<String> RESERVEDHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedHours").isBinary(false).build();
    private static final MarshallingInfo<String> TOTALRUNNINGHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalRunningHours").isBinary(false).build();
    private static final MarshallingInfo<String> COVERAGEHOURSPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoverageHoursPercentage").isBinary(false).build();
    private static final CoverageHoursMarshaller INSTANCE = new CoverageHoursMarshaller();

    private CoverageHoursMarshaller() {
    }

    public static CoverageHoursMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CoverageHours coverageHours, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)coverageHours, (String)"coverageHours");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)coverageHours.onDemandHours(), ONDEMANDHOURS_BINDING);
            protocolMarshaller.marshall((Object)coverageHours.reservedHours(), RESERVEDHOURS_BINDING);
            protocolMarshaller.marshall((Object)coverageHours.totalRunningHours(), TOTALRUNNINGHOURS_BINDING);
            protocolMarshaller.marshall((Object)coverageHours.coverageHoursPercentage(), COVERAGEHOURSPERCENTAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

