/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.services.costexplorer.model.Coverage;
import software.amazon.awssdk.services.costexplorer.transform.ReservationCoverageGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationCoverageGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, ReservationCoverageGroup> {
    private final Map<String, String> attributes;
    private final Coverage coverage;

    private ReservationCoverageGroup(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.coverage = builder.coverage;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Coverage coverage() {
        return this.coverage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationCoverageGroup)) {
            return false;
        }
        ReservationCoverageGroup other = (ReservationCoverageGroup)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.coverage(), other.coverage());
    }

    public String toString() {
        return ToString.builder((String)"ReservationCoverageGroup").add("Attributes", this.attributes()).add("Coverage", (Object)this.coverage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Coverage": {
                return Optional.ofNullable(clazz.cast(this.coverage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReservationCoverageGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Coverage coverage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationCoverageGroup model) {
            this.attributes(model.attributes);
            this.coverage(model.coverage);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Coverage.Builder getCoverage() {
            return this.coverage != null ? this.coverage.toBuilder() : null;
        }

        @Override
        public final Builder coverage(Coverage coverage) {
            this.coverage = coverage;
            return this;
        }

        public final void setCoverage(Coverage.BuilderImpl coverage) {
            this.coverage = coverage != null ? coverage.build() : null;
        }

        public ReservationCoverageGroup build() {
            return new ReservationCoverageGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationCoverageGroup> {
        public Builder attributes(Map<String, String> var1);

        public Builder coverage(Coverage var1);

        default public Builder coverage(Consumer<Coverage.Builder> coverage) {
            return this.coverage((Coverage)((Coverage.Builder)Coverage.builder().applyMutation(coverage)).build());
        }
    }
}

