/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.EC2InstanceDetails;
import software.amazon.awssdk.services.costexplorer.model.ESInstanceDetails;
import software.amazon.awssdk.services.costexplorer.model.ElastiCacheInstanceDetails;
import software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails;
import software.amazon.awssdk.services.costexplorer.model.RedshiftInstanceDetails;
import software.amazon.awssdk.services.costexplorer.transform.InstanceDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceDetails> {
    private final EC2InstanceDetails ec2InstanceDetails;
    private final RDSInstanceDetails rdsInstanceDetails;
    private final RedshiftInstanceDetails redshiftInstanceDetails;
    private final ElastiCacheInstanceDetails elastiCacheInstanceDetails;
    private final ESInstanceDetails esInstanceDetails;

    private InstanceDetails(BuilderImpl builder) {
        this.ec2InstanceDetails = builder.ec2InstanceDetails;
        this.rdsInstanceDetails = builder.rdsInstanceDetails;
        this.redshiftInstanceDetails = builder.redshiftInstanceDetails;
        this.elastiCacheInstanceDetails = builder.elastiCacheInstanceDetails;
        this.esInstanceDetails = builder.esInstanceDetails;
    }

    public EC2InstanceDetails ec2InstanceDetails() {
        return this.ec2InstanceDetails;
    }

    public RDSInstanceDetails rdsInstanceDetails() {
        return this.rdsInstanceDetails;
    }

    public RedshiftInstanceDetails redshiftInstanceDetails() {
        return this.redshiftInstanceDetails;
    }

    public ElastiCacheInstanceDetails elastiCacheInstanceDetails() {
        return this.elastiCacheInstanceDetails;
    }

    public ESInstanceDetails esInstanceDetails() {
        return this.esInstanceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.elastiCacheInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.esInstanceDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceDetails)) {
            return false;
        }
        InstanceDetails other = (InstanceDetails)obj;
        return Objects.equals(this.ec2InstanceDetails(), other.ec2InstanceDetails()) && Objects.equals(this.rdsInstanceDetails(), other.rdsInstanceDetails()) && Objects.equals(this.redshiftInstanceDetails(), other.redshiftInstanceDetails()) && Objects.equals(this.elastiCacheInstanceDetails(), other.elastiCacheInstanceDetails()) && Objects.equals(this.esInstanceDetails(), other.esInstanceDetails());
    }

    public String toString() {
        return ToString.builder((String)"InstanceDetails").add("EC2InstanceDetails", (Object)this.ec2InstanceDetails()).add("RDSInstanceDetails", (Object)this.rdsInstanceDetails()).add("RedshiftInstanceDetails", (Object)this.redshiftInstanceDetails()).add("ElastiCacheInstanceDetails", (Object)this.elastiCacheInstanceDetails()).add("ESInstanceDetails", (Object)this.esInstanceDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceDetails()));
            }
            case "RDSInstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.rdsInstanceDetails()));
            }
            case "RedshiftInstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.redshiftInstanceDetails()));
            }
            case "ElastiCacheInstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.elastiCacheInstanceDetails()));
            }
            case "ESInstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.esInstanceDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private EC2InstanceDetails ec2InstanceDetails;
        private RDSInstanceDetails rdsInstanceDetails;
        private RedshiftInstanceDetails redshiftInstanceDetails;
        private ElastiCacheInstanceDetails elastiCacheInstanceDetails;
        private ESInstanceDetails esInstanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceDetails model) {
            this.ec2InstanceDetails(model.ec2InstanceDetails);
            this.rdsInstanceDetails(model.rdsInstanceDetails);
            this.redshiftInstanceDetails(model.redshiftInstanceDetails);
            this.elastiCacheInstanceDetails(model.elastiCacheInstanceDetails);
            this.esInstanceDetails(model.esInstanceDetails);
        }

        public final EC2InstanceDetails.Builder getEC2InstanceDetails() {
            return this.ec2InstanceDetails != null ? this.ec2InstanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder ec2InstanceDetails(EC2InstanceDetails ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails;
            return this;
        }

        public final void setEC2InstanceDetails(EC2InstanceDetails.BuilderImpl ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails != null ? ec2InstanceDetails.build() : null;
        }

        public final RDSInstanceDetails.Builder getRDSInstanceDetails() {
            return this.rdsInstanceDetails != null ? this.rdsInstanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder rdsInstanceDetails(RDSInstanceDetails rdsInstanceDetails) {
            this.rdsInstanceDetails = rdsInstanceDetails;
            return this;
        }

        public final void setRDSInstanceDetails(RDSInstanceDetails.BuilderImpl rdsInstanceDetails) {
            this.rdsInstanceDetails = rdsInstanceDetails != null ? rdsInstanceDetails.build() : null;
        }

        public final RedshiftInstanceDetails.Builder getRedshiftInstanceDetails() {
            return this.redshiftInstanceDetails != null ? this.redshiftInstanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder redshiftInstanceDetails(RedshiftInstanceDetails redshiftInstanceDetails) {
            this.redshiftInstanceDetails = redshiftInstanceDetails;
            return this;
        }

        public final void setRedshiftInstanceDetails(RedshiftInstanceDetails.BuilderImpl redshiftInstanceDetails) {
            this.redshiftInstanceDetails = redshiftInstanceDetails != null ? redshiftInstanceDetails.build() : null;
        }

        public final ElastiCacheInstanceDetails.Builder getElastiCacheInstanceDetails() {
            return this.elastiCacheInstanceDetails != null ? this.elastiCacheInstanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder elastiCacheInstanceDetails(ElastiCacheInstanceDetails elastiCacheInstanceDetails) {
            this.elastiCacheInstanceDetails = elastiCacheInstanceDetails;
            return this;
        }

        public final void setElastiCacheInstanceDetails(ElastiCacheInstanceDetails.BuilderImpl elastiCacheInstanceDetails) {
            this.elastiCacheInstanceDetails = elastiCacheInstanceDetails != null ? elastiCacheInstanceDetails.build() : null;
        }

        public final ESInstanceDetails.Builder getESInstanceDetails() {
            return this.esInstanceDetails != null ? this.esInstanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder esInstanceDetails(ESInstanceDetails esInstanceDetails) {
            this.esInstanceDetails = esInstanceDetails;
            return this;
        }

        public final void setESInstanceDetails(ESInstanceDetails.BuilderImpl esInstanceDetails) {
            this.esInstanceDetails = esInstanceDetails != null ? esInstanceDetails.build() : null;
        }

        public InstanceDetails build() {
            return new InstanceDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceDetails> {
        public Builder ec2InstanceDetails(EC2InstanceDetails var1);

        default public Builder ec2InstanceDetails(Consumer<EC2InstanceDetails.Builder> ec2InstanceDetails) {
            return this.ec2InstanceDetails((EC2InstanceDetails)((EC2InstanceDetails.Builder)EC2InstanceDetails.builder().applyMutation(ec2InstanceDetails)).build());
        }

        public Builder rdsInstanceDetails(RDSInstanceDetails var1);

        default public Builder rdsInstanceDetails(Consumer<RDSInstanceDetails.Builder> rdsInstanceDetails) {
            return this.rdsInstanceDetails((RDSInstanceDetails)((RDSInstanceDetails.Builder)RDSInstanceDetails.builder().applyMutation(rdsInstanceDetails)).build());
        }

        public Builder redshiftInstanceDetails(RedshiftInstanceDetails var1);

        default public Builder redshiftInstanceDetails(Consumer<RedshiftInstanceDetails.Builder> redshiftInstanceDetails) {
            return this.redshiftInstanceDetails((RedshiftInstanceDetails)((RedshiftInstanceDetails.Builder)RedshiftInstanceDetails.builder().applyMutation(redshiftInstanceDetails)).build());
        }

        public Builder elastiCacheInstanceDetails(ElastiCacheInstanceDetails var1);

        default public Builder elastiCacheInstanceDetails(Consumer<ElastiCacheInstanceDetails.Builder> elastiCacheInstanceDetails) {
            return this.elastiCacheInstanceDetails((ElastiCacheInstanceDetails)((ElastiCacheInstanceDetails.Builder)ElastiCacheInstanceDetails.builder().applyMutation(elastiCacheInstanceDetails)).build());
        }

        public Builder esInstanceDetails(ESInstanceDetails var1);

        default public Builder esInstanceDetails(Consumer<ESInstanceDetails.Builder> esInstanceDetails) {
            return this.esInstanceDetails((ESInstanceDetails)((ESInstanceDetails.Builder)ESInstanceDetails.builder().applyMutation(esInstanceDetails)).build());
        }
    }
}

