/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinitionType;
import software.amazon.awssdk.services.costexplorer.transform.GroupDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, GroupDefinition> {
    private final String type;
    private final String key;

    private GroupDefinition(BuilderImpl builder) {
        this.type = builder.type;
        this.key = builder.key;
    }

    public GroupDefinitionType type() {
        return GroupDefinitionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupDefinition)) {
            return false;
        }
        GroupDefinition other = (GroupDefinition)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.key(), other.key());
    }

    public String toString() {
        return ToString.builder((String)"GroupDefinition").add("Type", (Object)this.typeAsString()).add("Key", (Object)this.key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupDefinition model) {
            this.type(model.type);
            this.key(model.key);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GroupDefinitionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public GroupDefinition build() {
            return new GroupDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupDefinition> {
        public Builder type(String var1);

        public Builder type(GroupDefinitionType var1);

        public Builder key(String var1);
    }
}

