/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.KeysCopier;
import software.amazon.awssdk.services.costexplorer.model.MetricValue;
import software.amazon.awssdk.services.costexplorer.model.MetricsCopier;
import software.amazon.awssdk.services.costexplorer.transform.GroupMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Group
implements StructuredPojo,
ToCopyableBuilder<Builder, Group> {
    private final List<String> keys;
    private final Map<String, MetricValue> metrics;

    private Group(BuilderImpl builder) {
        this.keys = builder.keys;
        this.metrics = builder.metrics;
    }

    public List<String> keys() {
        return this.keys;
    }

    public Map<String, MetricValue> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return Objects.equals(this.keys(), other.keys()) && Objects.equals(this.metrics(), other.metrics());
    }

    public String toString() {
        return ToString.builder((String)"Group").add("Keys", this.keys()).add("Metrics", this.metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private Map<String, MetricValue> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            this.keys(model.keys);
            this.metrics(model.metrics);
        }

        public final Collection<String> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = KeysCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = KeysCopier.copy(keys);
        }

        public final Map<String, MetricValue.Builder> getMetrics() {
            return this.metrics != null ? CollectionUtils.mapValues(this.metrics, MetricValue::toBuilder) : null;
        }

        @Override
        public final Builder metrics(Map<String, MetricValue> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, MetricValue.BuilderImpl> metrics) {
            this.metrics = MetricsCopier.copyFromBuilder(metrics);
        }

        public Group build() {
            return new Group(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Group> {
        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder metrics(Map<String, MetricValue> var1);
    }
}

