/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.ReservationAggregates;
import software.amazon.awssdk.services.costexplorer.model.UtilizationByTime;
import software.amazon.awssdk.services.costexplorer.model.UtilizationsByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationUtilizationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetReservationUtilizationResponse> {
    private final List<UtilizationByTime> utilizationsByTime;
    private final ReservationAggregates total;
    private final String nextPageToken;

    private GetReservationUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.utilizationsByTime = builder.utilizationsByTime;
        this.total = builder.total;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<UtilizationByTime> utilizationsByTime() {
        return this.utilizationsByTime;
    }

    public ReservationAggregates total() {
        return this.total;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationsByTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationUtilizationResponse)) {
            return false;
        }
        GetReservationUtilizationResponse other = (GetReservationUtilizationResponse)((Object)obj);
        return Objects.equals(this.utilizationsByTime(), other.utilizationsByTime()) && Objects.equals(this.total(), other.total()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReservationUtilizationResponse").add("UtilizationsByTime", this.utilizationsByTime()).add("Total", (Object)this.total()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtilizationsByTime": {
                return Optional.ofNullable(clazz.cast(this.utilizationsByTime()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<UtilizationByTime> utilizationsByTime = DefaultSdkAutoConstructList.getInstance();
        private ReservationAggregates total;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationUtilizationResponse model) {
            super(model);
            this.utilizationsByTime(model.utilizationsByTime);
            this.total(model.total);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<UtilizationByTime.Builder> getUtilizationsByTime() {
            return this.utilizationsByTime != null ? (Collection)this.utilizationsByTime.stream().map(UtilizationByTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utilizationsByTime(Collection<UtilizationByTime> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copy(utilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(UtilizationByTime ... utilizationsByTime) {
            this.utilizationsByTime(Arrays.asList(utilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(Consumer<UtilizationByTime.Builder> ... utilizationsByTime) {
            this.utilizationsByTime(Stream.of(utilizationsByTime).map(c -> (UtilizationByTime)((UtilizationByTime.Builder)UtilizationByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtilizationsByTime(Collection<UtilizationByTime.BuilderImpl> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copyFromBuilder(utilizationsByTime);
        }

        public final ReservationAggregates.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(ReservationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(ReservationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetReservationUtilizationResponse build() {
            return new GetReservationUtilizationResponse(this);
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    CopyableBuilder<Builder, GetReservationUtilizationResponse> {
        public Builder utilizationsByTime(Collection<UtilizationByTime> var1);

        public Builder utilizationsByTime(UtilizationByTime ... var1);

        public Builder utilizationsByTime(Consumer<UtilizationByTime.Builder> ... var1);

        public Builder total(ReservationAggregates var1);

        default public Builder total(Consumer<ReservationAggregates.Builder> total) {
            return this.total((ReservationAggregates)((ReservationAggregates.Builder)ReservationAggregates.builder().applyMutation(total)).build());
        }

        public Builder nextPageToken(String var1);
    }
}

