/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.ServiceSpecification;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationPurchaseRecommendationRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetReservationPurchaseRecommendationRequest> {
    private final String accountId;
    private final String service;
    private final String accountScope;
    private final String lookbackPeriodInDays;
    private final String termInYears;
    private final String paymentOption;
    private final ServiceSpecification serviceSpecification;
    private final Integer pageSize;
    private final String nextPageToken;

    private GetReservationPurchaseRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.service = builder.service;
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.serviceSpecification = builder.serviceSpecification;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    public String accountId() {
        return this.accountId;
    }

    public String service() {
        return this.service;
    }

    public AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public String accountScopeAsString() {
        return this.accountScope;
    }

    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public String termInYearsAsString() {
        return this.termInYears;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionAsString() {
        return this.paymentOption;
    }

    public ServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationPurchaseRecommendationRequest)) {
            return false;
        }
        GetReservationPurchaseRecommendationRequest other = (GetReservationPurchaseRecommendationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.serviceSpecification(), other.serviceSpecification()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReservationPurchaseRecommendationRequest").add("AccountId", (Object)this.accountId()).add("Service", (Object)this.service()).add("AccountScope", (Object)this.accountScopeAsString()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("ServiceSpecification", (Object)this.serviceSpecification()).add("PageSize", (Object)this.pageSize()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "ServiceSpecification": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecification()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String service;
        private String accountScope;
        private String lookbackPeriodInDays;
        private String termInYears;
        private String paymentOption;
        private ServiceSpecification serviceSpecification;
        private Integer pageSize;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationPurchaseRecommendationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.service(model.service);
            this.accountScope(model.accountScope);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.serviceSpecification(model.serviceSpecification);
            this.pageSize(model.pageSize);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getAccountScope() {
            return this.accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope.toString());
            return this;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        public final String getLookbackPeriodInDays() {
            return this.lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public final String getTermInYears() {
            return this.termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final ServiceSpecification.Builder getServiceSpecification() {
            return this.serviceSpecification != null ? this.serviceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder serviceSpecification(ServiceSpecification serviceSpecification) {
            this.serviceSpecification = serviceSpecification;
            return this;
        }

        public final void setServiceSpecification(ServiceSpecification.BuilderImpl serviceSpecification) {
            this.serviceSpecification = serviceSpecification != null ? serviceSpecification.build() : null;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservationPurchaseRecommendationRequest build() {
            return new GetReservationPurchaseRecommendationRequest(this);
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    CopyableBuilder<Builder, GetReservationPurchaseRecommendationRequest> {
        public Builder accountId(String var1);

        public Builder service(String var1);

        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder serviceSpecification(ServiceSpecification var1);

        default public Builder serviceSpecification(Consumer<ServiceSpecification.Builder> serviceSpecification) {
            return this.serviceSpecification((ServiceSpecification)((ServiceSpecification.Builder)ServiceSpecification.builder().applyMutation(serviceSpecification)).build());
        }

        public Builder pageSize(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

