/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.Coverage;
import software.amazon.awssdk.services.costexplorer.model.CoverageByTime;
import software.amazon.awssdk.services.costexplorer.model.CoveragesByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationCoverageResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetReservationCoverageResponse> {
    private final List<CoverageByTime> coveragesByTime;
    private final Coverage total;
    private final String nextPageToken;

    private GetReservationCoverageResponse(BuilderImpl builder) {
        super(builder);
        this.coveragesByTime = builder.coveragesByTime;
        this.total = builder.total;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<CoverageByTime> coveragesByTime() {
        return this.coveragesByTime;
    }

    public Coverage total() {
        return this.total;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coveragesByTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationCoverageResponse)) {
            return false;
        }
        GetReservationCoverageResponse other = (GetReservationCoverageResponse)((Object)obj);
        return Objects.equals(this.coveragesByTime(), other.coveragesByTime()) && Objects.equals(this.total(), other.total()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReservationCoverageResponse").add("CoveragesByTime", this.coveragesByTime()).add("Total", (Object)this.total()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoveragesByTime": {
                return Optional.ofNullable(clazz.cast(this.coveragesByTime()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CoverageByTime> coveragesByTime = DefaultSdkAutoConstructList.getInstance();
        private Coverage total;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationCoverageResponse model) {
            super(model);
            this.coveragesByTime(model.coveragesByTime);
            this.total(model.total);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<CoverageByTime.Builder> getCoveragesByTime() {
            return this.coveragesByTime != null ? (Collection)this.coveragesByTime.stream().map(CoverageByTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder coveragesByTime(Collection<CoverageByTime> coveragesByTime) {
            this.coveragesByTime = CoveragesByTimeCopier.copy(coveragesByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coveragesByTime(CoverageByTime ... coveragesByTime) {
            this.coveragesByTime(Arrays.asList(coveragesByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coveragesByTime(Consumer<CoverageByTime.Builder> ... coveragesByTime) {
            this.coveragesByTime(Stream.of(coveragesByTime).map(c -> (CoverageByTime)((CoverageByTime.Builder)CoverageByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCoveragesByTime(Collection<CoverageByTime.BuilderImpl> coveragesByTime) {
            this.coveragesByTime = CoveragesByTimeCopier.copyFromBuilder(coveragesByTime);
        }

        public final Coverage.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(Coverage total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Coverage.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetReservationCoverageResponse build() {
            return new GetReservationCoverageResponse(this);
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    CopyableBuilder<Builder, GetReservationCoverageResponse> {
        public Builder coveragesByTime(Collection<CoverageByTime> var1);

        public Builder coveragesByTime(CoverageByTime ... var1);

        public Builder coveragesByTime(Consumer<CoverageByTime.Builder> ... var1);

        public Builder total(Coverage var1);

        default public Builder total(Consumer<Coverage.Builder> total) {
            return this.total((Coverage)((Coverage.Builder)Coverage.builder().applyMutation(total)).build());
        }

        public Builder nextPageToken(String var1);
    }
}

