/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.costexplorer.model.Context;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Dimension;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDimensionValuesRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetDimensionValuesRequest> {
    private final String searchString;
    private final DateInterval timePeriod;
    private final String dimension;
    private final String context;
    private final String nextPageToken;

    private GetDimensionValuesRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.dimension = builder.dimension;
        this.context = builder.context;
        this.nextPageToken = builder.nextPageToken;
    }

    public String searchString() {
        return this.searchString;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public Dimension dimension() {
        return Dimension.fromValue(this.dimension);
    }

    public String dimensionAsString() {
        return this.dimension;
    }

    public Context context() {
        return Context.fromValue(this.context);
    }

    public String contextAsString() {
        return this.context;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesRequest)) {
            return false;
        }
        GetDimensionValuesRequest other = (GetDimensionValuesRequest)((Object)obj);
        return Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.dimensionAsString(), other.dimensionAsString()) && Objects.equals(this.contextAsString(), other.contextAsString()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDimensionValuesRequest").add("SearchString", (Object)this.searchString()).add("TimePeriod", (Object)this.timePeriod()).add("Dimension", (Object)this.dimensionAsString()).add("Context", (Object)this.contextAsString()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimensionAsString()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.contextAsString()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String searchString;
        private DateInterval timePeriod;
        private String dimension;
        private String context;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesRequest model) {
            super(model);
            this.searchString(model.searchString);
            this.timePeriod(model.timePeriod);
            this.dimension(model.dimension);
            this.context(model.context);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return this.searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getDimension() {
            return this.dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(Dimension dimension) {
            this.dimension(dimension.toString());
            return this;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(Context context) {
            this.context(context.toString());
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionValuesRequest build() {
            return new GetDimensionValuesRequest(this);
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    CopyableBuilder<Builder, GetDimensionValuesRequest> {
        public Builder searchString(String var1);

        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder dimension(String var1);

        public Builder dimension(Dimension var1);

        public Builder context(String var1);

        public Builder context(Context var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

