/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinition;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinitionsCopier;
import software.amazon.awssdk.services.costexplorer.model.ResultByTime;
import software.amazon.awssdk.services.costexplorer.model.ResultsByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostAndUsageResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetCostAndUsageResponse> {
    private final String nextPageToken;
    private final List<GroupDefinition> groupDefinitions;
    private final List<ResultByTime> resultsByTime;

    private GetCostAndUsageResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.groupDefinitions = builder.groupDefinitions;
        this.resultsByTime = builder.resultsByTime;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public List<GroupDefinition> groupDefinitions() {
        return this.groupDefinitions;
    }

    public List<ResultByTime> resultsByTime() {
        return this.resultsByTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultsByTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageResponse)) {
            return false;
        }
        GetCostAndUsageResponse other = (GetCostAndUsageResponse)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.groupDefinitions(), other.groupDefinitions()) && Objects.equals(this.resultsByTime(), other.resultsByTime());
    }

    public String toString() {
        return ToString.builder((String)"GetCostAndUsageResponse").add("NextPageToken", (Object)this.nextPageToken()).add("GroupDefinitions", this.groupDefinitions()).add("ResultsByTime", this.resultsByTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "GroupDefinitions": {
                return Optional.ofNullable(clazz.cast(this.groupDefinitions()));
            }
            case "ResultsByTime": {
                return Optional.ofNullable(clazz.cast(this.resultsByTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private List<GroupDefinition> groupDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<ResultByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageResponse model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.groupDefinitions(model.groupDefinitions);
            this.resultsByTime(model.resultsByTime);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Collection<GroupDefinition.Builder> getGroupDefinitions() {
            return this.groupDefinitions != null ? (Collection)this.groupDefinitions.stream().map(GroupDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copy(groupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(GroupDefinition ... groupDefinitions) {
            this.groupDefinitions(Arrays.asList(groupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(Consumer<GroupDefinition.Builder> ... groupDefinitions) {
            this.groupDefinitions(Stream.of(groupDefinitions).map(c -> (GroupDefinition)((GroupDefinition.Builder)GroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroupDefinitions(Collection<GroupDefinition.BuilderImpl> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copyFromBuilder(groupDefinitions);
        }

        public final Collection<ResultByTime.Builder> getResultsByTime() {
            return this.resultsByTime != null ? (Collection)this.resultsByTime.stream().map(ResultByTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultsByTime(Collection<ResultByTime> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(ResultByTime ... resultsByTime) {
            this.resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<ResultByTime.Builder> ... resultsByTime) {
            this.resultsByTime(Stream.of(resultsByTime).map(c -> (ResultByTime)((ResultByTime.Builder)ResultByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResultsByTime(Collection<ResultByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copyFromBuilder(resultsByTime);
        }

        @Override
        public GetCostAndUsageResponse build() {
            return new GetCostAndUsageResponse(this);
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    CopyableBuilder<Builder, GetCostAndUsageResponse> {
        public Builder nextPageToken(String var1);

        public Builder groupDefinitions(Collection<GroupDefinition> var1);

        public Builder groupDefinitions(GroupDefinition ... var1);

        public Builder groupDefinitions(Consumer<GroupDefinition.Builder> ... var1);

        public Builder resultsByTime(Collection<ResultByTime> var1);

        public Builder resultsByTime(ResultByTime ... var1);

        public Builder resultsByTime(Consumer<ResultByTime.Builder> ... var1);
    }
}

