/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.services.costexplorer.transform.DimensionValuesWithAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionValuesWithAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, DimensionValuesWithAttributes> {
    private final String value;
    private final Map<String, String> attributes;

    private DimensionValuesWithAttributes(BuilderImpl builder) {
        this.value = builder.value;
        this.attributes = builder.attributes;
    }

    public String value() {
        return this.value;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionValuesWithAttributes)) {
            return false;
        }
        DimensionValuesWithAttributes other = (DimensionValuesWithAttributes)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"DimensionValuesWithAttributes").add("Value", (Object)this.value()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DimensionValuesWithAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionValuesWithAttributes model) {
            this.value(model.value);
            this.attributes(model.attributes);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public DimensionValuesWithAttributes build() {
            return new DimensionValuesWithAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DimensionValuesWithAttributes> {
        public Builder value(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

