/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.transform.DateIntervalMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateInterval
implements StructuredPojo,
ToCopyableBuilder<Builder, DateInterval> {
    private final String start;
    private final String end;

    private DateInterval(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    public String start() {
        return this.start;
    }

    public String end() {
        return this.end;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval other = (DateInterval)obj;
        return Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end());
    }

    public String toString() {
        return ToString.builder((String)"DateInterval").add("Start", (Object)this.start()).add("End", (Object)this.end()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DateIntervalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String start;
        private String end;

        private BuilderImpl() {
        }

        private BuilderImpl(DateInterval model) {
            this.start(model.start);
            this.end(model.end);
        }

        public final String getStart() {
            return this.start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public DateInterval build() {
            return new DateInterval(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DateInterval> {
        public Builder start(String var1);

        public Builder end(String var1);
    }
}

