/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.transform.CoverageHoursMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageHours
implements StructuredPojo,
ToCopyableBuilder<Builder, CoverageHours> {
    private final String onDemandHours;
    private final String reservedHours;
    private final String totalRunningHours;
    private final String coverageHoursPercentage;

    private CoverageHours(BuilderImpl builder) {
        this.onDemandHours = builder.onDemandHours;
        this.reservedHours = builder.reservedHours;
        this.totalRunningHours = builder.totalRunningHours;
        this.coverageHoursPercentage = builder.coverageHoursPercentage;
    }

    public String onDemandHours() {
        return this.onDemandHours;
    }

    public String reservedHours() {
        return this.reservedHours;
    }

    public String totalRunningHours() {
        return this.totalRunningHours;
    }

    public String coverageHoursPercentage() {
        return this.coverageHoursPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRunningHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.coverageHoursPercentage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageHours)) {
            return false;
        }
        CoverageHours other = (CoverageHours)obj;
        return Objects.equals(this.onDemandHours(), other.onDemandHours()) && Objects.equals(this.reservedHours(), other.reservedHours()) && Objects.equals(this.totalRunningHours(), other.totalRunningHours()) && Objects.equals(this.coverageHoursPercentage(), other.coverageHoursPercentage());
    }

    public String toString() {
        return ToString.builder((String)"CoverageHours").add("OnDemandHours", (Object)this.onDemandHours()).add("ReservedHours", (Object)this.reservedHours()).add("TotalRunningHours", (Object)this.totalRunningHours()).add("CoverageHoursPercentage", (Object)this.coverageHoursPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OnDemandHours": {
                return Optional.ofNullable(clazz.cast(this.onDemandHours()));
            }
            case "ReservedHours": {
                return Optional.ofNullable(clazz.cast(this.reservedHours()));
            }
            case "TotalRunningHours": {
                return Optional.ofNullable(clazz.cast(this.totalRunningHours()));
            }
            case "CoverageHoursPercentage": {
                return Optional.ofNullable(clazz.cast(this.coverageHoursPercentage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoverageHoursMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String onDemandHours;
        private String reservedHours;
        private String totalRunningHours;
        private String coverageHoursPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageHours model) {
            this.onDemandHours(model.onDemandHours);
            this.reservedHours(model.reservedHours);
            this.totalRunningHours(model.totalRunningHours);
            this.coverageHoursPercentage(model.coverageHoursPercentage);
        }

        public final String getOnDemandHours() {
            return this.onDemandHours;
        }

        @Override
        public final Builder onDemandHours(String onDemandHours) {
            this.onDemandHours = onDemandHours;
            return this;
        }

        public final void setOnDemandHours(String onDemandHours) {
            this.onDemandHours = onDemandHours;
        }

        public final String getReservedHours() {
            return this.reservedHours;
        }

        @Override
        public final Builder reservedHours(String reservedHours) {
            this.reservedHours = reservedHours;
            return this;
        }

        public final void setReservedHours(String reservedHours) {
            this.reservedHours = reservedHours;
        }

        public final String getTotalRunningHours() {
            return this.totalRunningHours;
        }

        @Override
        public final Builder totalRunningHours(String totalRunningHours) {
            this.totalRunningHours = totalRunningHours;
            return this;
        }

        public final void setTotalRunningHours(String totalRunningHours) {
            this.totalRunningHours = totalRunningHours;
        }

        public final String getCoverageHoursPercentage() {
            return this.coverageHoursPercentage;
        }

        @Override
        public final Builder coverageHoursPercentage(String coverageHoursPercentage) {
            this.coverageHoursPercentage = coverageHoursPercentage;
            return this;
        }

        public final void setCoverageHoursPercentage(String coverageHoursPercentage) {
            this.coverageHoursPercentage = coverageHoursPercentage;
        }

        public CoverageHours build() {
            return new CoverageHours(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CoverageHours> {
        public Builder onDemandHours(String var1);

        public Builder reservedHours(String var1);

        public Builder totalRunningHours(String var1);

        public Builder coverageHoursPercentage(String var1);
    }
}

