/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.Coverage;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup;
import software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroupsCopier;
import software.amazon.awssdk.services.costexplorer.transform.CoverageByTimeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageByTime
implements StructuredPojo,
ToCopyableBuilder<Builder, CoverageByTime> {
    private final DateInterval timePeriod;
    private final List<ReservationCoverageGroup> groups;
    private final Coverage total;

    private CoverageByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.groups = builder.groups;
        this.total = builder.total;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public List<ReservationCoverageGroup> groups() {
        return this.groups;
    }

    public Coverage total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageByTime)) {
            return false;
        }
        CoverageByTime other = (CoverageByTime)obj;
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.total(), other.total());
    }

    public String toString() {
        return ToString.builder((String)"CoverageByTime").add("TimePeriod", (Object)this.timePeriod()).add("Groups", this.groups()).add("Total", (Object)this.total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CoverageByTimeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private List<ReservationCoverageGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private Coverage total;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageByTime model) {
            this.timePeriod(model.timePeriod);
            this.groups(model.groups);
            this.total(model.total);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final Collection<ReservationCoverageGroup.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(ReservationCoverageGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<ReservationCoverageGroup> groups) {
            this.groups = ReservationCoverageGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(ReservationCoverageGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<ReservationCoverageGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (ReservationCoverageGroup)((ReservationCoverageGroup.Builder)ReservationCoverageGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<ReservationCoverageGroup.BuilderImpl> groups) {
            this.groups = ReservationCoverageGroupsCopier.copyFromBuilder(groups);
        }

        public final Coverage.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(Coverage total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Coverage.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public CoverageByTime build() {
            return new CoverageByTime(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CoverageByTime> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder groups(Collection<ReservationCoverageGroup> var1);

        public Builder groups(ReservationCoverageGroup ... var1);

        public Builder groups(Consumer<ReservationCoverageGroup.Builder> ... var1);

        public Builder total(Coverage var1);

        default public Builder total(Consumer<Coverage.Builder> total) {
            return this.total((Coverage)((Coverage.Builder)Coverage.builder().applyMutation(total)).build());
        }
    }
}

