/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costandusagereport.CostAndUsageReportAsyncClient;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;

public class DescribeReportDefinitionsPublisher
implements SdkPublisher<DescribeReportDefinitionsResponse> {
    private final CostAndUsageReportAsyncClient client;
    private final DescribeReportDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReportDefinitionsPublisher(CostAndUsageReportAsyncClient client, DescribeReportDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReportDefinitionsPublisher(CostAndUsageReportAsyncClient client, DescribeReportDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReportDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReportDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReportDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeReportDefinitionsResponse> {
        private DescribeReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReportDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReportDefinitionsResponse> nextPage(DescribeReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReportDefinitionsPublisher.this.client.describeReportDefinitions(DescribeReportDefinitionsPublisher.this.firstRequest);
            }
            return DescribeReportDefinitionsPublisher.this.client.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

