/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costandusagereport.model.CostAndUsageReportResponse;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReportDefinitionsResponse
extends CostAndUsageReportResponse
implements ToCopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
    private static final SdkField<List<ReportDefinition>> REPORT_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportDefinitions").getter(DescribeReportDefinitionsResponse.getter(DescribeReportDefinitionsResponse::reportDefinitions)).setter(DescribeReportDefinitionsResponse.setter(Builder::reportDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReportDefinitionsResponse.getter(DescribeReportDefinitionsResponse::nextToken)).setter(DescribeReportDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ReportDefinition> reportDefinitions;
    private final String nextToken;

    private DescribeReportDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.reportDefinitions = builder.reportDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReportDefinitions() {
        return this.reportDefinitions != null && !(this.reportDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ReportDefinition> reportDefinitions() {
        return this.reportDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportDefinitions() ? this.reportDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportDefinitionsResponse)) {
            return false;
        }
        DescribeReportDefinitionsResponse other = (DescribeReportDefinitionsResponse)((Object)obj);
        return this.hasReportDefinitions() == other.hasReportDefinitions() && Objects.equals(this.reportDefinitions(), other.reportDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReportDefinitionsResponse").add("ReportDefinitions", this.hasReportDefinitions() ? this.reportDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportDefinitions": {
                return Optional.ofNullable(clazz.cast(this.reportDefinitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportDefinitionsResponse, T> g) {
        return obj -> g.apply((DescribeReportDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostAndUsageReportResponse.BuilderImpl
    implements Builder {
        private List<ReportDefinition> reportDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportDefinitionsResponse model) {
            super(model);
            this.reportDefinitions(model.reportDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<ReportDefinition.Builder> getReportDefinitions() {
            List<ReportDefinition.Builder> result = ReportDefinitionListCopier.copyToBuilder(this.reportDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(ReportDefinition ... reportDefinitions) {
            this.reportDefinitions(Arrays.asList(reportDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(Consumer<ReportDefinition.Builder> ... reportDefinitions) {
            this.reportDefinitions(Stream.of(reportDefinitions).map(c -> (ReportDefinition)((ReportDefinition.Builder)ReportDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReportDefinitions(Collection<ReportDefinition.BuilderImpl> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copyFromBuilder(reportDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReportDefinitionsResponse build() {
            return new DescribeReportDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostAndUsageReportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
        public Builder reportDefinitions(Collection<ReportDefinition> var1);

        public Builder reportDefinitions(ReportDefinition ... var1);

        public Builder reportDefinitions(Consumer<ReportDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

