/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TimeUnit {
    HOURLY("HOURLY"),
    DAILY("DAILY"),
    MONTHLY("MONTHLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TimeUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TimeUnit.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeUnit> knownValues() {
        return Stream.of(TimeUnit.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

