/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReportDefinitionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
    private final List<ReportDefinition> reportDefinitions;
    private final String nextToken;

    private DescribeReportDefinitionsResponse(BuilderImpl builder) {
        this.reportDefinitions = builder.reportDefinitions;
        this.nextToken = builder.nextToken;
    }

    public List<ReportDefinition> reportDefinitions() {
        return this.reportDefinitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reportDefinitions() == null ? 0 : this.reportDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportDefinitionsResponse)) {
            return false;
        }
        DescribeReportDefinitionsResponse other = (DescribeReportDefinitionsResponse)((Object)obj);
        if (other.reportDefinitions() == null ^ this.reportDefinitions() == null) {
            return false;
        }
        if (other.reportDefinitions() != null && !other.reportDefinitions().equals(this.reportDefinitions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reportDefinitions() != null) {
            sb.append("ReportDefinitions: ").append(this.reportDefinitions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ReportDefinition> reportDefinitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportDefinitionsResponse model) {
            this.setReportDefinitions(model.reportDefinitions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ReportDefinition> getReportDefinitions() {
            return this.reportDefinitions;
        }

        @Override
        public final Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(ReportDefinition ... reportDefinitions) {
            this.reportDefinitions(Arrays.asList(reportDefinitions));
            return this;
        }

        public final void setReportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeReportDefinitionsResponse build() {
            return new DescribeReportDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
        public Builder reportDefinitions(Collection<ReportDefinition> var1);

        public Builder reportDefinitions(ReportDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

