/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.costandusagereport.model.AWSRegion;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifact;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifactListCopier;
import software.amazon.awssdk.services.costandusagereport.model.CompressionFormat;
import software.amazon.awssdk.services.costandusagereport.model.ReportFormat;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElement;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElementListCopier;
import software.amazon.awssdk.services.costandusagereport.model.TimeUnit;
import software.amazon.awssdk.services.costandusagereport.transform.ReportDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ReportDefinition> {
    private final String reportName;
    private final String timeUnit;
    private final String format;
    private final String compression;
    private final List<String> additionalSchemaElements;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String s3Region;
    private final List<String> additionalArtifacts;

    private ReportDefinition(BuilderImpl builder) {
        this.reportName = builder.reportName;
        this.timeUnit = builder.timeUnit;
        this.format = builder.format;
        this.compression = builder.compression;
        this.additionalSchemaElements = builder.additionalSchemaElements;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
        this.additionalArtifacts = builder.additionalArtifacts;
    }

    public String reportName() {
        return this.reportName;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public String format() {
        return this.format;
    }

    public String compression() {
        return this.compression;
    }

    public List<String> additionalSchemaElements() {
        return this.additionalSchemaElements;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public String s3Region() {
        return this.s3Region;
    }

    public List<String> additionalArtifacts() {
        return this.additionalArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reportName() == null ? 0 : this.reportName().hashCode());
        hashCode = 31 * hashCode + (this.timeUnit() == null ? 0 : this.timeUnit().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.compression() == null ? 0 : this.compression().hashCode());
        hashCode = 31 * hashCode + (this.additionalSchemaElements() == null ? 0 : this.additionalSchemaElements().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Prefix() == null ? 0 : this.s3Prefix().hashCode());
        hashCode = 31 * hashCode + (this.s3Region() == null ? 0 : this.s3Region().hashCode());
        hashCode = 31 * hashCode + (this.additionalArtifacts() == null ? 0 : this.additionalArtifacts().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        if (other.reportName() == null ^ this.reportName() == null) {
            return false;
        }
        if (other.reportName() != null && !other.reportName().equals(this.reportName())) {
            return false;
        }
        if (other.timeUnit() == null ^ this.timeUnit() == null) {
            return false;
        }
        if (other.timeUnit() != null && !other.timeUnit().equals(this.timeUnit())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.compression() == null ^ this.compression() == null) {
            return false;
        }
        if (other.compression() != null && !other.compression().equals(this.compression())) {
            return false;
        }
        if (other.additionalSchemaElements() == null ^ this.additionalSchemaElements() == null) {
            return false;
        }
        if (other.additionalSchemaElements() != null && !other.additionalSchemaElements().equals(this.additionalSchemaElements())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Prefix() == null ^ this.s3Prefix() == null) {
            return false;
        }
        if (other.s3Prefix() != null && !other.s3Prefix().equals(this.s3Prefix())) {
            return false;
        }
        if (other.s3Region() == null ^ this.s3Region() == null) {
            return false;
        }
        if (other.s3Region() != null && !other.s3Region().equals(this.s3Region())) {
            return false;
        }
        if (other.additionalArtifacts() == null ^ this.additionalArtifacts() == null) {
            return false;
        }
        return other.additionalArtifacts() == null || other.additionalArtifacts().equals(this.additionalArtifacts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reportName() != null) {
            sb.append("ReportName: ").append(this.reportName()).append(",");
        }
        if (this.timeUnit() != null) {
            sb.append("TimeUnit: ").append(this.timeUnit()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.compression() != null) {
            sb.append("Compression: ").append(this.compression()).append(",");
        }
        if (this.additionalSchemaElements() != null) {
            sb.append("AdditionalSchemaElements: ").append(this.additionalSchemaElements()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Prefix() != null) {
            sb.append("S3Prefix: ").append(this.s3Prefix()).append(",");
        }
        if (this.s3Region() != null) {
            sb.append("S3Region: ").append(this.s3Region()).append(",");
        }
        if (this.additionalArtifacts() != null) {
            sb.append("AdditionalArtifacts: ").append(this.additionalArtifacts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String reportName;
        private String timeUnit;
        private String format;
        private String compression;
        private List<String> additionalSchemaElements;
        private String s3Bucket;
        private String s3Prefix;
        private String s3Region;
        private List<String> additionalArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            this.setReportName(model.reportName);
            this.setTimeUnit(model.timeUnit);
            this.setFormat(model.format);
            this.setCompression(model.compression);
            this.setAdditionalSchemaElements(model.additionalSchemaElements);
            this.setS3Bucket(model.s3Bucket);
            this.setS3Prefix(model.s3Prefix);
            this.setS3Region(model.s3Region);
            this.setAdditionalArtifacts(model.additionalArtifacts);
        }

        public final String getReportName() {
            return this.reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(ReportFormat format) {
            this.format(format.toString());
        }

        public final String getCompression() {
            return this.compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionFormat compression) {
            this.compression(compression.toString());
            return this;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        public final void setCompression(CompressionFormat compression) {
            this.compression(compression.toString());
        }

        public final Collection<String> getAdditionalSchemaElements() {
            return this.additionalSchemaElements;
        }

        @Override
        public final Builder additionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElements(String ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElements(SchemaElement ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
        }

        @SafeVarargs
        public final void setAdditionalSchemaElements(String ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements));
        }

        @SafeVarargs
        public final void setAdditionalSchemaElements(SchemaElement ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        @Override
        public final Builder s3Region(AWSRegion s3Region) {
            this.s3Region(s3Region.toString());
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        public final void setS3Region(AWSRegion s3Region) {
            this.s3Region(s3Region.toString());
        }

        public final Collection<String> getAdditionalArtifacts() {
            return this.additionalArtifacts;
        }

        @Override
        public final Builder additionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(String ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(AdditionalArtifact ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
        }

        @SafeVarargs
        public final void setAdditionalArtifacts(String ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts));
        }

        @SafeVarargs
        public final void setAdditionalArtifacts(AdditionalArtifact ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public ReportDefinition build() {
            return new ReportDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportDefinition> {
        public Builder reportName(String var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder format(String var1);

        public Builder format(ReportFormat var1);

        public Builder compression(String var1);

        public Builder compression(CompressionFormat var1);

        public Builder additionalSchemaElements(Collection<String> var1);

        public Builder additionalSchemaElements(String ... var1);

        public Builder additionalSchemaElements(SchemaElement ... var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3Region(String var1);

        public Builder s3Region(AWSRegion var1);

        public Builder additionalArtifacts(Collection<String> var1);

        public Builder additionalArtifacts(String ... var1);

        public Builder additionalArtifacts(AdditionalArtifact ... var1);
    }
}

