/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlOperationStatus;
import software.amazon.awssdk.services.controltower.model.ControlOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlOperation> {
    private static final SdkField<String> CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlIdentifier").getter(ControlOperation.getter(ControlOperation::controlIdentifier)).setter(ControlOperation.setter(Builder::controlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifier").build()}).build();
    private static final SdkField<String> ENABLED_CONTROL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enabledControlIdentifier").getter(ControlOperation.getter(ControlOperation::enabledControlIdentifier)).setter(ControlOperation.setter(Builder::enabledControlIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlIdentifier").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ControlOperation.getter(ControlOperation::endTime)).setter(ControlOperation.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationIdentifier").getter(ControlOperation.getter(ControlOperation::operationIdentifier)).setter(ControlOperation.setter(Builder::operationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(ControlOperation.getter(ControlOperation::operationTypeAsString)).setter(ControlOperation.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ControlOperation.getter(ControlOperation::startTime)).setter(ControlOperation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ControlOperation.getter(ControlOperation::statusAsString)).setter(ControlOperation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ControlOperation.getter(ControlOperation::statusMessage)).setter(ControlOperation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(ControlOperation.getter(ControlOperation::targetIdentifier)).setter(ControlOperation.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIER_FIELD, ENABLED_CONTROL_IDENTIFIER_FIELD, END_TIME_FIELD, OPERATION_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD, START_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TARGET_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String controlIdentifier;
    private final String enabledControlIdentifier;
    private final Instant endTime;
    private final String operationIdentifier;
    private final String operationType;
    private final Instant startTime;
    private final String status;
    private final String statusMessage;
    private final String targetIdentifier;

    private ControlOperation(BuilderImpl builder) {
        this.controlIdentifier = builder.controlIdentifier;
        this.enabledControlIdentifier = builder.enabledControlIdentifier;
        this.endTime = builder.endTime;
        this.operationIdentifier = builder.operationIdentifier;
        this.operationType = builder.operationType;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.targetIdentifier = builder.targetIdentifier;
    }

    public final String controlIdentifier() {
        return this.controlIdentifier;
    }

    public final String enabledControlIdentifier() {
        return this.enabledControlIdentifier;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String operationIdentifier() {
        return this.operationIdentifier;
    }

    public final ControlOperationType operationType() {
        return ControlOperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final ControlOperationStatus status() {
        return ControlOperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledControlIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlOperation)) {
            return false;
        }
        ControlOperation other = (ControlOperation)obj;
        return Objects.equals(this.controlIdentifier(), other.controlIdentifier()) && Objects.equals(this.enabledControlIdentifier(), other.enabledControlIdentifier()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.operationIdentifier(), other.operationIdentifier()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ControlOperation").add("ControlIdentifier", (Object)this.controlIdentifier()).add("EnabledControlIdentifier", (Object)this.enabledControlIdentifier()).add("EndTime", (Object)this.endTime()).add("OperationIdentifier", (Object)this.operationIdentifier()).add("OperationType", (Object)this.operationTypeAsString()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("TargetIdentifier", (Object)this.targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifier()));
            }
            case "enabledControlIdentifier": {
                return Optional.ofNullable(clazz.cast(this.enabledControlIdentifier()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "operationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.operationIdentifier()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("controlIdentifier", CONTROL_IDENTIFIER_FIELD);
        map.put("enabledControlIdentifier", ENABLED_CONTROL_IDENTIFIER_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("operationIdentifier", OPERATION_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlOperation, T> g) {
        return obj -> g.apply((ControlOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlIdentifier;
        private String enabledControlIdentifier;
        private Instant endTime;
        private String operationIdentifier;
        private String operationType;
        private Instant startTime;
        private String status;
        private String statusMessage;
        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlOperation model) {
            this.controlIdentifier(model.controlIdentifier);
            this.enabledControlIdentifier(model.enabledControlIdentifier);
            this.endTime(model.endTime);
            this.operationIdentifier(model.operationIdentifier);
            this.operationType(model.operationType);
            this.startTime(model.startTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.targetIdentifier(model.targetIdentifier);
        }

        public final String getControlIdentifier() {
            return this.controlIdentifier;
        }

        public final void setControlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
        }

        @Override
        public final Builder controlIdentifier(String controlIdentifier) {
            this.controlIdentifier = controlIdentifier;
            return this;
        }

        public final String getEnabledControlIdentifier() {
            return this.enabledControlIdentifier;
        }

        public final void setEnabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
        }

        @Override
        public final Builder enabledControlIdentifier(String enabledControlIdentifier) {
            this.enabledControlIdentifier = enabledControlIdentifier;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getOperationIdentifier() {
            return this.operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(ControlOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public ControlOperation build() {
            return new ControlOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlOperation> {
        public Builder controlIdentifier(String var1);

        public Builder enabledControlIdentifier(String var1);

        public Builder endTime(Instant var1);

        public Builder operationIdentifier(String var1);

        public Builder operationType(String var1);

        public Builder operationType(ControlOperationType var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ControlOperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder targetIdentifier(String var1);
    }
}

