/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.controltower.auth.scheme.ControlTowerAuthSchemeParams;
import software.amazon.awssdk.services.controltower.auth.scheme.ControlTowerAuthSchemeProvider;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class PreferredControlTowerAuthSchemeProvider
implements ControlTowerAuthSchemeProvider {
    private final ControlTowerAuthSchemeProvider delegate;
    private final List<String> authSchemePreference;

    public PreferredControlTowerAuthSchemeProvider(ControlTowerAuthSchemeProvider delegate, List<String> authSchemePreference) {
        this.delegate = delegate;
        this.authSchemePreference = authSchemePreference != null ? authSchemePreference : Collections.emptyList();
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(ControlTowerAuthSchemeParams params) {
        List<AuthSchemeOption> candidateAuthSchemes = this.delegate.resolveAuthScheme(params);
        if (CollectionUtils.isNullOrEmpty(this.authSchemePreference)) {
            return candidateAuthSchemes;
        }
        ArrayList<AuthSchemeOption> authSchemes = new ArrayList<AuthSchemeOption>();
        this.authSchemePreference.forEach(preferredSchemeId -> candidateAuthSchemes.stream().filter(candidate -> {
            String candidateSchemeName = candidate.schemeId().contains("#") ? candidate.schemeId().split("#")[1] : candidate.schemeId();
            return candidateSchemeName.equals(preferredSchemeId);
        }).findFirst().ifPresent(authSchemes::add));
        candidateAuthSchemes.forEach(candidate -> {
            if (!authSchemes.contains(candidate)) {
                authSchemes.add((AuthSchemeOption)candidate);
            }
        });
        return authSchemes;
    }
}

