/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.LandingZoneSummary;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZonesResponse;

public class ListLandingZonesPublisher
implements SdkPublisher<ListLandingZonesResponse> {
    private final ControlTowerAsyncClient client;
    private final ListLandingZonesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLandingZonesPublisher(ControlTowerAsyncClient client, ListLandingZonesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLandingZonesPublisher(ControlTowerAsyncClient client, ListLandingZonesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLandingZonesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLandingZonesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LandingZoneSummary> landingZones() {
        Function<ListLandingZonesResponse, Iterator> getIterator = response -> {
            if (response != null && response.landingZones() != null) {
                return response.landingZones().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLandingZonesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLandingZonesResponseFetcher
    implements AsyncPageFetcher<ListLandingZonesResponse> {
        private ListLandingZonesResponseFetcher() {
        }

        public boolean hasNextPage(ListLandingZonesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLandingZonesResponse> nextPage(ListLandingZonesResponse previousPage) {
            if (previousPage == null) {
                return ListLandingZonesPublisher.this.client.listLandingZones(ListLandingZonesPublisher.this.firstRequest);
            }
            return ListLandingZonesPublisher.this.client.listLandingZones((ListLandingZonesRequest)((Object)ListLandingZonesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

