/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.ControlOperationSummary;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsResponse;

public class ListControlOperationsPublisher
implements SdkPublisher<ListControlOperationsResponse> {
    private final ControlTowerAsyncClient client;
    private final ListControlOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlOperationsPublisher(ControlTowerAsyncClient client, ListControlOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlOperationsPublisher(ControlTowerAsyncClient client, ListControlOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ControlOperationSummary> controlOperations() {
        Function<ListControlOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlOperations() != null) {
                return response.controlOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListControlOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListControlOperationsResponseFetcher
    implements AsyncPageFetcher<ListControlOperationsResponse> {
        private ListControlOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlOperationsResponse> nextPage(ListControlOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListControlOperationsPublisher.this.client.listControlOperations(ListControlOperationsPublisher.this.firstRequest);
            }
            return ListControlOperationsPublisher.this.client.listControlOperations((ListControlOperationsRequest)((Object)ListControlOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

