/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlTowerResponse;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationSummary;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLandingZoneOperationsResponse
extends ControlTowerResponse
implements ToCopyableBuilder<Builder, ListLandingZoneOperationsResponse> {
    private static final SdkField<List<LandingZoneOperationSummary>> LANDING_ZONE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("landingZoneOperations").getter(ListLandingZoneOperationsResponse.getter(ListLandingZoneOperationsResponse::landingZoneOperations)).setter(ListLandingZoneOperationsResponse.setter(Builder::landingZoneOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("landingZoneOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LandingZoneOperationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLandingZoneOperationsResponse.getter(ListLandingZoneOperationsResponse::nextToken)).setter(ListLandingZoneOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANDING_ZONE_OPERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLandingZoneOperationsResponse.memberNameToFieldInitializer();
    private final List<LandingZoneOperationSummary> landingZoneOperations;
    private final String nextToken;

    private ListLandingZoneOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.landingZoneOperations = builder.landingZoneOperations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLandingZoneOperations() {
        return this.landingZoneOperations != null && !(this.landingZoneOperations instanceof SdkAutoConstructList);
    }

    public final List<LandingZoneOperationSummary> landingZoneOperations() {
        return this.landingZoneOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLandingZoneOperations() ? this.landingZoneOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLandingZoneOperationsResponse)) {
            return false;
        }
        ListLandingZoneOperationsResponse other = (ListLandingZoneOperationsResponse)((Object)obj);
        return this.hasLandingZoneOperations() == other.hasLandingZoneOperations() && Objects.equals(this.landingZoneOperations(), other.landingZoneOperations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLandingZoneOperationsResponse").add("LandingZoneOperations", this.hasLandingZoneOperations() ? this.landingZoneOperations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "landingZoneOperations": {
                return Optional.ofNullable(clazz.cast(this.landingZoneOperations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("landingZoneOperations", LANDING_ZONE_OPERATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLandingZoneOperationsResponse, T> g) {
        return obj -> g.apply((ListLandingZoneOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerResponse.BuilderImpl
    implements Builder {
        private List<LandingZoneOperationSummary> landingZoneOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLandingZoneOperationsResponse model) {
            super(model);
            this.landingZoneOperations(model.landingZoneOperations);
            this.nextToken(model.nextToken);
        }

        public final List<LandingZoneOperationSummary.Builder> getLandingZoneOperations() {
            List<LandingZoneOperationSummary.Builder> result = LandingZoneOperationsCopier.copyToBuilder(this.landingZoneOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLandingZoneOperations(Collection<LandingZoneOperationSummary.BuilderImpl> landingZoneOperations) {
            this.landingZoneOperations = LandingZoneOperationsCopier.copyFromBuilder(landingZoneOperations);
        }

        @Override
        public final Builder landingZoneOperations(Collection<LandingZoneOperationSummary> landingZoneOperations) {
            this.landingZoneOperations = LandingZoneOperationsCopier.copy(landingZoneOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landingZoneOperations(LandingZoneOperationSummary ... landingZoneOperations) {
            this.landingZoneOperations(Arrays.asList(landingZoneOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landingZoneOperations(Consumer<LandingZoneOperationSummary.Builder> ... landingZoneOperations) {
            this.landingZoneOperations(Stream.of(landingZoneOperations).map(c -> (LandingZoneOperationSummary)((LandingZoneOperationSummary.Builder)LandingZoneOperationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLandingZoneOperationsResponse build() {
            return new ListLandingZoneOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlTowerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLandingZoneOperationsResponse> {
        public Builder landingZoneOperations(Collection<LandingZoneOperationSummary> var1);

        public Builder landingZoneOperations(LandingZoneOperationSummary ... var1);

        public Builder landingZoneOperations(Consumer<LandingZoneOperationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

