/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationSummary;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsResponse;

public class ListLandingZoneOperationsPublisher
implements SdkPublisher<ListLandingZoneOperationsResponse> {
    private final ControlTowerAsyncClient client;
    private final ListLandingZoneOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLandingZoneOperationsPublisher(ControlTowerAsyncClient client, ListLandingZoneOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLandingZoneOperationsPublisher(ControlTowerAsyncClient client, ListLandingZoneOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLandingZoneOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLandingZoneOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LandingZoneOperationSummary> landingZoneOperations() {
        Function<ListLandingZoneOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.landingZoneOperations() != null) {
                return response.landingZoneOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLandingZoneOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLandingZoneOperationsResponseFetcher
    implements AsyncPageFetcher<ListLandingZoneOperationsResponse> {
        private ListLandingZoneOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLandingZoneOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLandingZoneOperationsResponse> nextPage(ListLandingZoneOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListLandingZoneOperationsPublisher.this.client.listLandingZoneOperations(ListLandingZoneOperationsPublisher.this.firstRequest);
            }
            return ListLandingZoneOperationsPublisher.this.client.listLandingZoneOperations((ListLandingZoneOperationsRequest)((Object)ListLandingZoneOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

