/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParametersCopier;
import software.amazon.awssdk.services.controltower.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableBaselineRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, EnableBaselineRequest> {
    private static final SdkField<String> BASELINE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineIdentifier").getter(EnableBaselineRequest.getter(EnableBaselineRequest::baselineIdentifier)).setter(EnableBaselineRequest.setter(Builder::baselineIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifier").build()}).build();
    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineVersion").getter(EnableBaselineRequest.getter(EnableBaselineRequest::baselineVersion)).setter(EnableBaselineRequest.setter(Builder::baselineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()}).build();
    private static final SdkField<List<EnabledBaselineParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(EnableBaselineRequest.getter(EnableBaselineRequest::parameters)).setter(EnableBaselineRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledBaselineParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(EnableBaselineRequest.getter(EnableBaselineRequest::tags)).setter(EnableBaselineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(EnableBaselineRequest.getter(EnableBaselineRequest::targetIdentifier)).setter(EnableBaselineRequest.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_IDENTIFIER_FIELD, BASELINE_VERSION_FIELD, PARAMETERS_FIELD, TAGS_FIELD, TARGET_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("baselineIdentifier", BASELINE_IDENTIFIER_FIELD);
            this.put("baselineVersion", BASELINE_VERSION_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        }
    });
    private final String baselineIdentifier;
    private final String baselineVersion;
    private final List<EnabledBaselineParameter> parameters;
    private final Map<String, String> tags;
    private final String targetIdentifier;

    private EnableBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.baselineIdentifier = builder.baselineIdentifier;
        this.baselineVersion = builder.baselineVersion;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
        this.targetIdentifier = builder.targetIdentifier;
    }

    public final String baselineIdentifier() {
        return this.baselineIdentifier;
    }

    public final String baselineVersion() {
        return this.baselineVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<EnabledBaselineParameter> parameters() {
        return this.parameters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableBaselineRequest)) {
            return false;
        }
        EnableBaselineRequest other = (EnableBaselineRequest)((Object)obj);
        return Objects.equals(this.baselineIdentifier(), other.baselineIdentifier()) && Objects.equals(this.baselineVersion(), other.baselineVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"EnableBaselineRequest").add("BaselineIdentifier", (Object)this.baselineIdentifier()).add("BaselineVersion", (Object)this.baselineVersion()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Tags", this.hasTags() ? this.tags() : null).add("TargetIdentifier", (Object)this.targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baselineIdentifier": {
                return Optional.ofNullable(clazz.cast(this.baselineIdentifier()));
            }
            case "baselineVersion": {
                return Optional.ofNullable(clazz.cast(this.baselineVersion()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableBaselineRequest, T> g) {
        return obj -> g.apply((EnableBaselineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String baselineIdentifier;
        private String baselineVersion;
        private List<EnabledBaselineParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableBaselineRequest model) {
            super(model);
            this.baselineIdentifier(model.baselineIdentifier);
            this.baselineVersion(model.baselineVersion);
            this.parameters(model.parameters);
            this.tags(model.tags);
            this.targetIdentifier(model.targetIdentifier);
        }

        public final String getBaselineIdentifier() {
            return this.baselineIdentifier;
        }

        public final void setBaselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
        }

        @Override
        public final Builder baselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        public final String getBaselineVersion() {
            return this.baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final List<EnabledBaselineParameter.Builder> getParameters() {
            List<EnabledBaselineParameter.Builder> result = EnabledBaselineParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledBaselineParameter.BuilderImpl> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledBaselineParameter> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledBaselineParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledBaselineParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (EnabledBaselineParameter)((EnabledBaselineParameter.Builder)EnabledBaselineParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableBaselineRequest build() {
            return new EnableBaselineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableBaselineRequest> {
        public Builder baselineIdentifier(String var1);

        public Builder baselineVersion(String var1);

        public Builder parameters(Collection<EnabledBaselineParameter> var1);

        public Builder parameters(EnabledBaselineParameter ... var1);

        public Builder parameters(Consumer<EnabledBaselineParameter.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

