/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.EnablementStatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledBaselineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledBaselineSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::arn)).setter(EnabledBaselineSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> BASELINE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineIdentifier").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::baselineIdentifier)).setter(EnabledBaselineSummary.setter(Builder::baselineIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifier").build()}).build();
    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineVersion").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::baselineVersion)).setter(EnabledBaselineSummary.setter(Builder::baselineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()}).build();
    private static final SdkField<String> PARENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIdentifier").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::parentIdentifier)).setter(EnabledBaselineSummary.setter(Builder::parentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifier").build()}).build();
    private static final SdkField<EnablementStatusSummary> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusSummary").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::statusSummary)).setter(EnabledBaselineSummary.setter(Builder::statusSummary)).constructor(EnablementStatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(EnabledBaselineSummary.getter(EnabledBaselineSummary::targetIdentifier)).setter(EnabledBaselineSummary.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BASELINE_IDENTIFIER_FIELD, BASELINE_VERSION_FIELD, PARENT_IDENTIFIER_FIELD, STATUS_SUMMARY_FIELD, TARGET_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("baselineIdentifier", BASELINE_IDENTIFIER_FIELD);
            this.put("baselineVersion", BASELINE_VERSION_FIELD);
            this.put("parentIdentifier", PARENT_IDENTIFIER_FIELD);
            this.put("statusSummary", STATUS_SUMMARY_FIELD);
            this.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String baselineIdentifier;
    private final String baselineVersion;
    private final String parentIdentifier;
    private final EnablementStatusSummary statusSummary;
    private final String targetIdentifier;

    private EnabledBaselineSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.baselineIdentifier = builder.baselineIdentifier;
        this.baselineVersion = builder.baselineVersion;
        this.parentIdentifier = builder.parentIdentifier;
        this.statusSummary = builder.statusSummary;
        this.targetIdentifier = builder.targetIdentifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final String baselineIdentifier() {
        return this.baselineIdentifier;
    }

    public final String baselineVersion() {
        return this.baselineVersion;
    }

    public final String parentIdentifier() {
        return this.parentIdentifier;
    }

    public final EnablementStatusSummary statusSummary() {
        return this.statusSummary;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineSummary)) {
            return false;
        }
        EnabledBaselineSummary other = (EnabledBaselineSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baselineIdentifier(), other.baselineIdentifier()) && Objects.equals(this.baselineVersion(), other.baselineVersion()) && Objects.equals(this.parentIdentifier(), other.parentIdentifier()) && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledBaselineSummary").add("Arn", (Object)this.arn()).add("BaselineIdentifier", (Object)this.baselineIdentifier()).add("BaselineVersion", (Object)this.baselineVersion()).add("ParentIdentifier", (Object)this.parentIdentifier()).add("StatusSummary", (Object)this.statusSummary()).add("TargetIdentifier", (Object)this.targetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "baselineIdentifier": {
                return Optional.ofNullable(clazz.cast(this.baselineIdentifier()));
            }
            case "baselineVersion": {
                return Optional.ofNullable(clazz.cast(this.baselineVersion()));
            }
            case "parentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.parentIdentifier()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineSummary, T> g) {
        return obj -> g.apply((EnabledBaselineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String baselineIdentifier;
        private String baselineVersion;
        private String parentIdentifier;
        private EnablementStatusSummary statusSummary;
        private String targetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineSummary model) {
            this.arn(model.arn);
            this.baselineIdentifier(model.baselineIdentifier);
            this.baselineVersion(model.baselineVersion);
            this.parentIdentifier(model.parentIdentifier);
            this.statusSummary(model.statusSummary);
            this.targetIdentifier(model.targetIdentifier);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBaselineIdentifier() {
            return this.baselineIdentifier;
        }

        public final void setBaselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
        }

        @Override
        public final Builder baselineIdentifier(String baselineIdentifier) {
            this.baselineIdentifier = baselineIdentifier;
            return this;
        }

        public final String getBaselineVersion() {
            return this.baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final String getParentIdentifier() {
            return this.parentIdentifier;
        }

        public final void setParentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
        }

        @Override
        public final Builder parentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
            return this;
        }

        public final EnablementStatusSummary.Builder getStatusSummary() {
            return this.statusSummary != null ? this.statusSummary.toBuilder() : null;
        }

        public final void setStatusSummary(EnablementStatusSummary.BuilderImpl statusSummary) {
            this.statusSummary = statusSummary != null ? statusSummary.build() : null;
        }

        @Override
        public final Builder statusSummary(EnablementStatusSummary statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public EnabledBaselineSummary build() {
            return new EnabledBaselineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledBaselineSummary> {
        public Builder arn(String var1);

        public Builder baselineIdentifier(String var1);

        public Builder baselineVersion(String var1);

        public Builder parentIdentifier(String var1);

        public Builder statusSummary(EnablementStatusSummary var1);

        default public Builder statusSummary(Consumer<EnablementStatusSummary.Builder> statusSummary) {
            return this.statusSummary((EnablementStatusSummary)((EnablementStatusSummary.Builder)EnablementStatusSummary.builder().applyMutation(statusSummary)).build());
        }

        public Builder targetIdentifier(String var1);
    }
}

