/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationStatus;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LandingZoneOperationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LandingZoneOperationSummary> {
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationIdentifier").getter(LandingZoneOperationSummary.getter(LandingZoneOperationSummary::operationIdentifier)).setter(LandingZoneOperationSummary.setter(Builder::operationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(LandingZoneOperationSummary.getter(LandingZoneOperationSummary::operationTypeAsString)).setter(LandingZoneOperationSummary.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LandingZoneOperationSummary.getter(LandingZoneOperationSummary::statusAsString)).setter(LandingZoneOperationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operationIdentifier;
    private final String operationType;
    private final String status;

    private LandingZoneOperationSummary(BuilderImpl builder) {
        this.operationIdentifier = builder.operationIdentifier;
        this.operationType = builder.operationType;
        this.status = builder.status;
    }

    public final String operationIdentifier() {
        return this.operationIdentifier;
    }

    public final LandingZoneOperationType operationType() {
        return LandingZoneOperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final LandingZoneOperationStatus status() {
        return LandingZoneOperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneOperationSummary)) {
            return false;
        }
        LandingZoneOperationSummary other = (LandingZoneOperationSummary)obj;
        return Objects.equals(this.operationIdentifier(), other.operationIdentifier()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LandingZoneOperationSummary").add("OperationIdentifier", (Object)this.operationIdentifier()).add("OperationType", (Object)this.operationTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.operationIdentifier()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneOperationSummary, T> g) {
        return obj -> g.apply((LandingZoneOperationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationIdentifier;
        private String operationType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneOperationSummary model) {
            this.operationIdentifier(model.operationIdentifier);
            this.operationType(model.operationType);
            this.status(model.status);
        }

        public final String getOperationIdentifier() {
            return this.operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(LandingZoneOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public LandingZoneOperationSummary build() {
            return new LandingZoneOperationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LandingZoneOperationSummary> {
        public Builder operationIdentifier(String var1);

        public Builder operationType(String var1);

        public Builder operationType(LandingZoneOperationType var1);

        public Builder status(String var1);

        public Builder status(LandingZoneOperationStatus var1);
    }
}

