/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationStatus;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationStatusesCopier;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationType;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LandingZoneOperationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LandingZoneOperationFilter> {
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(LandingZoneOperationFilter.getter(LandingZoneOperationFilter::statusesAsStrings)).setter(LandingZoneOperationFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(LandingZoneOperationFilter.getter(LandingZoneOperationFilter::typesAsStrings)).setter(LandingZoneOperationFilter.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUSES_FIELD, TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> statuses;
    private final List<String> types;

    private LandingZoneOperationFilter(BuilderImpl builder) {
        this.statuses = builder.statuses;
        this.types = builder.types;
    }

    public final List<LandingZoneOperationStatus> statuses() {
        return LandingZoneOperationStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final List<LandingZoneOperationType> types() {
        return LandingZoneOperationTypesCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneOperationFilter)) {
            return false;
        }
        LandingZoneOperationFilter other = (LandingZoneOperationFilter)obj;
        return this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LandingZoneOperationFilter").add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("Types", this.hasTypes() ? this.typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneOperationFilter, T> g) {
        return obj -> g.apply((LandingZoneOperationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneOperationFilter model) {
            this.statusesWithStrings(model.statuses);
            this.typesWithStrings(model.types);
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = LandingZoneOperationStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = LandingZoneOperationStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<LandingZoneOperationStatus> statuses) {
            this.statuses = LandingZoneOperationStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(LandingZoneOperationStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = LandingZoneOperationTypesCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = LandingZoneOperationTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<LandingZoneOperationType> types) {
            this.types = LandingZoneOperationTypesCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(LandingZoneOperationType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public LandingZoneOperationFilter build() {
            return new LandingZoneOperationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LandingZoneOperationFilter> {
        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<LandingZoneOperationStatus> var1);

        public Builder statuses(LandingZoneOperationStatus ... var1);

        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<LandingZoneOperationType> var1);

        public Builder types(LandingZoneOperationType ... var1);
    }
}

